<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MODERN === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: var(--transition);
}

.card-modern:hover {
    box-shadow: var(--card-shadow-hover);
}

/* === BUTTONS MODERN === */
.btn-modern {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.6rem 1.2rem;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-1px);
    box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
}

.btn-modern-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, var(--success-color) 0%, #2ecc71 100%);
    color: white;
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}

/* === PROFILE PICTURE === */
.picture-container {
    position: relative;
    cursor: pointer;
    text-align: center;
}
.picture {
    width: 150px;
    height: 150px;
    background-color: #e9ecef;
    border: 4px solid #fff;
    color: #FFFFFF;
    border-radius: 50%;
    margin: 0px auto;
    overflow: hidden;
    transition: all 0.2s;
    box-shadow: 0px 10px 25px 0px rgba(0,0,0,0.1);
}
.picture:hover {
    border-color: var(--primary-color);
}
.picture input[type="file"] {
    cursor: pointer;
    display: block;
    height: 100%;
    left: 0;
    opacity: 0 !important;
    position: absolute;
    top: 0;
    width: 100%;
}
.picture-src {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* === FORMULARIO MODERN === */
.form-group-modern {
    position: relative;
    margin-bottom: 25px;
}

.form-group-modern input.form-control,
.form-group-modern select.form-control,
.form-group-modern textarea.form-control {
    border: none;
    border-bottom: 2px solid #e9ecef;
    border-radius: 0;
    padding: 10px 0;
    background: transparent;
    font-weight: 500;
    transition: all 0.3s;
    box-shadow: none;
}

.form-group-modern .bootstrap-select > .dropdown-toggle {
    border: none;
    border-bottom: 2px solid #e9ecef;
    background: transparent !important;
    box-shadow: none !important;
    padding: 10px 0;
    border-radius: 0;
}

.form-group-modern input.form-control:focus,
.form-group-modern select.form-control:focus,
.form-group-modern textarea.form-control:focus,
.form-group-modern .filter-option {
    border-bottom-color: var(--primary-color);
}

.form-group-modern label {
    color: #adb5bd;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    transition: all 0.3s;
    margin-bottom: 5px;
    display: block;
}

.form-group-modern input:focus ~ label,
.form-group-modern input:valid ~ label,
.form-group-modern textarea:focus ~ label,
.form-group-modern textarea:valid ~ label {
    color: var(--primary-color);
    font-weight: 600;
}

/* Switch Polish */
.switch label input[type=checkbox]:checked + .lever {
    background-color: #aeb5ea; /* Lighter primary */
}
.switch label input[type=checkbox]:checked + .lever:after {
    background-color: var(--primary-color);
    left: 24px;
}
.switch label .lever {
    width: 50px;
    height: 24px;
    margin: 0;
    background-color: #e9ecef;
    border-radius: 24px;
}
.switch label .lever:after {
    width: 18px;
    height: 18px;
    background-color: #adb5bd;
    border-radius: 50%;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    top: 3px;
    left: 4px;
    transition: all 0.3s ease;
}
</style>

<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<div class="row page-titles-modern animate-in">
    <div class="col-md-5 align-self-center">
        <h4 class="text-white">Ajustes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste"><i class="fa fa-home mr-1"></i>Inicio</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste">Empresa</a></span>
            <span class="breadcrumb-item active">Datos de la empresa</span>
        </div>
    </div>
</div>

<form id="form" method="post" enctype="multipart/form-data">
<input type="hidden" name="usuid" id="usuid" value="<?php echo Session::get('usuid'); ?>"/>
<div class="row">
    <div class="col-md-12">
        <div class="card card-modern h-100">
            <div class="card-body">
                <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-id-badge font-18 mr-2"></i> Datos generales</h4>
                <h6 class="card-subtitle mb-4 text-muted">Información de tu empresa</h6>
                <div class="row floating-labels pr-4">
                    <div class="col-md-8">
                        <div class="form-group m-b-40 form-group-modern">
                            <input type="text" name="nombre_comercial" id="nombre_comercial" class="form-control input-mayus" autocomplete="off">
                            <span class="bar"></span>
                            <label for="nomb_com"><i class="ti-bookmark-alt mr-1"></i> Nombre comercial</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group m-b-40 form-group-modern">
                            <input type="text" name="celular" id="celular" class="form-control" autocomplete="off">
                            <span class="bar"></span>
                            <label for="celular"><i class="ti-mobile mr-1"></i> Teléfono</label>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group m-b-40 form-group-modern">
                            <input type="text" name="direccion_comercial" id="direccion_comercial" class="form-control input-mayus" autocomplete="off" required>
                            <span class="bar"></span>
                            <label for="direccion_comercial"><i class="ti-location-pin mr-1"></i> Dirección comercial</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body sunat b-t">
                <div class="m-t-20">
                    <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-receipt font-18 mr-2"></i> Facturación electrónica (Perú)</h4>
                    <h6 class="card-subtitle mb-4 text-muted">Información Sunat</h6>

                    <!-- Hidden Inputs for Logic -->
                    <input type="hidden" name="sunat" id="sunat_hidden"/>
                    <input type="hidden" name="modo" id="modo_hidden"/>
                    <input type="hidden" name="ose" id="hidden_ose"/>
                    <input type="hidden" name="ose_url" id="ose_url"/>
                    <input type="hidden" name="amazonas" id="hidden_amazonas"/>
                    <input type="hidden" name="certpse" id="certpse_hidden">

                    <div class="row m-t-40">
                        <!-- Left Column: Logo -->
                        <div class="col-md-4 text-center border-right">
                            <div style="position: relative; display: inline-block;">
                                <a href="javascript:void(0)" onclick="anularlogo()" class="text-danger" style="position: absolute; right: 0; top: 0; z-index: 10;" title="Eliminar logo"><i class="fa fa-trash"></i></a>
                                <div class="picture-container">
                                    <div class="picture">
                                        <img src="<?php echo URL; ?>public/images/empresa/<?php echo Session::get('logo'); ?>" class="picture-src" id="wizardPicturePreview-2" title=""/>
                                        <input type="hidden" name="logo" id="logo" value="<?php echo Session::get('logo'); ?>" />
                                        <input type="file" name="imagen" id="wizard-picture">
                                    </div>      
                                    <h6 class="text-center mt-3 text-primary font-weight-bold" style="cursor: pointer;"><i class="fa fa-camera mr-1"></i> Cambiar Imagen</h6>
                                </div>
                            </div>
                        </div>

                        <!-- Right Column: Switches & Config -->
                        <div class="col-md-8 px-4">
                            <!-- Conectar con Sunat -->
                            <div class="d-flex align-items-center mb-4">
                                <div class="btn btn-warning btn-circle text-white mr-3"><i class="ti-cloud"></i></div>
                                <div>
                                    <h5 class="mb-0 font-weight-bold">Conectar con Sunat</h5>
                                    <small class="text-muted">Activar la conexión con Sunat.</small>
                                </div>
                                <div class="ml-auto switch">
                                    <label>
                                        <input type="checkbox" id="sunat"><span class="lever switch-col-light-green"></span>
                                    </label>
                                </div>
                            </div>

                            <!-- Producción -->
                            <div class="d-flex align-items-center mb-4">
                                <div class="btn btn-warning btn-circle text-white mr-3"><i class="ti-files"></i></div>
                                <div>
                                    <h5 class="mb-0 font-weight-bold">Producción *</h5>
                                    <small class="text-muted">Empezar a enviar los documentos a Sunat.</small><br>
                                    <small class="text-muted font-10">* Si esta opción se encuentra desactivada, estaría en modo Beta.</small>
                                </div>
                                <div class="ml-auto switch">
                                    <label>
                                        <input type="checkbox" id="modo"><span class="lever switch-col-light-green"></span>
                                    </label>
                                </div>
                            </div>

                             <!-- Cert PSE -->
                             <div class="d-flex align-items-center mb-4">
                                <div class="btn btn-warning btn-circle text-white mr-3"><i class="ti-id-badge"></i></div>
                                <div>
                                    <h5 class="mb-0 font-weight-bold">Cert PSE</h5>
                                    <small class="text-muted">Activar Certificado PSE.</small>
                                </div>
                                <div class="ml-auto switch">
                                    <label>
                                        <input type="checkbox" id="certpse"><span class="lever switch-col-light-green"></span>
                                    </label>
                                </div>
                            </div>

                            <!-- Checkboxes OSE / Amazonia -->
                            <div class="row mt-2">
                                <div class="col-md-6 mb-2">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="ose">
                                        <label class="custom-control-label" for="ose">OSE</label>
                                    </div>
                                    <!-- OSE URL Input (Hidden by default via JS) -->
                                    <div class="mt-2 ose_url" style="display: none;">
                                        <input type="text" class="form-control form-control-sm" placeholder="URL OSE" value="<?php echo Session::get('ose_url'); ?>" name="ose_url_input" id="ose_url_input" onchange="$('#ose_url').val(this.value)">
                                    </div>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="amazonas">
                                        <label class="custom-control-label" for="amazonas">ACTIVAR LEYENDA AMAZONÍA</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Existing Form Fields (Rest of the form) -->
                    <div class="row floating-labels m-t-40 pr-4">
                        <div class="col-md-4">
                            <div class="form-group m-b-40 ent form-group-modern">
                                <input type="text" name="ruc" id="ruc" value="" class="form-control" maxlength="<?php echo Session::get('tribCar'); ?>" autocomplete="off" required>
                                <span class="bar"></span>
                                <label for="ruc" class="lblruc"><i class="ti-id-badge mr-1"></i> <?php echo Session::get('tribAcr'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group m-b-40 form-group-modern">
                                <input type="text" name="razon_social" id="razon_social" class="form-control input-mayus" autocomplete="off" required>
                                <span class="bar"></span>
                                <label for="razon_social"><i class="ti-agenda mr-1"></i> Razón social</label>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group m-b-40 form-group-modern">
                                <input type="text" name="direccion_fiscal" id="direccion_fiscal" class="form-control input-mayus" autocomplete="off" required>
                                <span class="bar"></span>
                                <label for="direccion_fiscal"><i class="ti-location-pin mr-1"></i> Dirección fiscal</label>
                            </div>
                        </div>
                        <div class="col-lg-6 b-r">
                            <div class="row m-t-10">
                                <div class="col-md-6">
                                    <div class="form-group m-b-40 ent form-group-modern">
                                        <input type="text" name="ubigeo" id="ubigeo" value="" class="form-control sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="ubigeo"><i class="ti-map mr-1"></i> Ubigeo</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <input type="text" name="departamento" id="departamento" value="" class="form-control input-mayus sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="departamento"><i class="ti-map-alt mr-1"></i> Departamento</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <input type="text" name="provincia" id="provincia" value="" class="form-control input-mayus sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="provincia"><i class="ti-map-alt mr-1"></i> Provincia</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <input type="text" name="distrito" id="distrito" value="" class="form-control input-mayus sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="distrito"><i class="ti-map-alt mr-1"></i> Distrito</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="row floating-labels m-t-10">
                                <div class="col-md-5 endpoint_sunat">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <input type="text" name="usuariosol" id="usuariosol" value="" class="form-control sunat" autocomplete="off" >
                                        <span class="bar"></span>
                                        <label for="usuariosol"><i class="ti-user mr-1"></i> Usuario SOL</label>
                                    </div>
                                </div>
                                <div class="col-md-5 endpoint_sunat">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <input type="text" name="clavesol" id="clavesol" value="" class="form-control sunat" autocomplete="off" >
                                        <span class="bar"></span>
                                        <label for="clavesol"><i class="ti-key mr-1"></i> Clave SOL</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <input type="text" name="clavecertificado" id="clavecertificado" value="" class="form-control sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="clavecertificado"><i class="ti-lock mr-1"></i> Contraseña certificado</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <span class="btn btn-outline-info btn-block btn-file btn-modern">
                                            <i class="fa fa-upload mr-2"></i> Subir certificado <input type="file" name="file_certificado" id="file_certificado" accept=".pfx,.PFX,.p12,.P12">
                                        </span>
                                        <label for="file_certificado" style="display:none;">Subir Certificado</label>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-2 m-b-40">
                                    <h6 class="border-bottom pb-2">Consulta integrada de CPE - Validador de documentos <i class="fa fa-info-circle text-info" data-toggle="tooltip" data-placement="top" title="Validador en producción"></i></h6>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <input type="text" name="client_id" id="client_id" value="" class="form-control sunat" autocomplete="off" >
                                        <span class="bar"></span>
                                        <label for="clavecertificado"><i class="ti-key mr-1"></i> Client ID</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <input type="text" name="client_secret" id="client_secret" value="" class="form-control sunat" autocomplete="off" >
                                        <span class="bar"></span>
                                        <label for="clavecertificado"><i class="ti-lock mr-1"></i> Client Secret (Clave)</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer bg-white border-top-0">
                <div class="text-right">
                    <a href="<?php echo URL; ?>ajuste" class="btn btn-secondary btn-modern">Cancelar</a>
                    <button class="btn btn-success btn-modern btn-modern-success" type="submit">Guardar Cambios</button>
                </div>
            </div>
        </div>
    </div>
</div>
</form>
