<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MODERN === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: var(--transition);
}

.card-modern:hover {
    box-shadow: var(--card-shadow-hover);
}

/* === TABS MODERNOS === */
.nav-tabs-modern {
    border-bottom: 2px solid #e9ecef;
    margin-bottom: 0;
}

.nav-tabs-modern .nav-link {
    border: none;
    color: #6c757d;
    font-weight: 500;
    padding: 1rem 1.5rem;
    position: relative;
    transition: var(--transition);
}

.nav-tabs-modern .nav-link:hover {
    color: var(--primary-color);
    background: transparent;
}

.nav-tabs-modern .nav-link.active {
    color: var(--primary-color);
    background: transparent;
    border-bottom: 3px solid var(--primary-color);
}

/* === SIDEBAR CATEGORIES === */
.sidebar-modern .list-group-item {
    border: none;
    padding: 0.75rem 1rem;
    margin-bottom: 0.5rem;
    border-radius: 8px;
    transition: var(--transition);
    color: #6c757d;
    background: transparent;
}

.sidebar-modern .list-group-item:hover,
.sidebar-modern .list-group-item.active {
    background: rgba(86, 100, 210, 0.1);
    color: var(--primary-color);
    font-weight: 600;
}

/* === BUTTONS MODERN === */
.btn-modern {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.6rem 1.2rem;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-1px);
    box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
}

.btn-modern-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, var(--success-color) 0%, #2ecc71 100%);
    color: white;
}

/* === TABLA MODERN === */
.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    background-color: #667eea !important; /* Fallback */
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%) !important;
    color: white !important;
    border: none !important;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.005);
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}
/* === INTERNAL FORM DEEP MODERNIZATION === */
/* File Upload / Wizard Modernization */
.picture-container-modern {
    position: relative;
    cursor: pointer;
    text-align: center;
    transition: all 0.3s ease;
}
.picture-container-modern .picture {
    width: 140px;
    height: 140px;
    background-color: #f8f9fa;
    border: 2px dashed #dce2e6; /* Dashed border for "dropzone" feel */
    color: #adb5bd;
    border-radius: 50%;
    margin: 0px auto;
    overflow: hidden;
    transition: all 0.3s;
    position: relative;
    display: flex;
    justify-content: center;
    align-items: center;
}
.picture-container-modern:hover .picture {
    border-color: var(--primary-color);
    box-shadow: 0 5px 15px rgba(86, 100, 210, 0.2);
    transform: scale(1.02);
}
.picture-container-modern input[type="file"] {
    cursor: pointer;
    display: block;
    height: 100%;
    left: 0;
    opacity: 0 !important;
    position: absolute;
    top: 0;
    width: 100%;
    z-index: 100;
}
.picture-src {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* Segmented Control (Radio Group) */
.btn-group-segments {
    background-color: #f1f3f5;
    padding: 4px;
    border-radius: 12px;
    display: flex;
    width: 100%;
}
.btn-group-segments .btn {
    border: none;
    background: transparent;
    color: #6c757d;
    border-radius: 10px;
    box-shadow: none;
    font-weight: 500;
    flex: 1;
    transition: all 0.2s;
    margin: 0 2px;
}
.btn-group-segments .btn:hover {
    color: var(--primary-color);
}
.btn-group-segments .btn.active {
    background-color: white;
    color: var(--primary-color);
    box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    font-weight: 600;
}
/* === RESPONSIVE UTILS === */
@media (max-width: 768px) {
    .category-list-scroll {
        height: 250px !important; /* Reduced height for mobile */
    }
    
    .nav-tabs-modern {
        flex-wrap: nowrap !important;
        overflow-x: auto;
        overflow-y: hidden;
        -webkit-overflow-scrolling: touch;
        justify-content: flex-start !important;
        padding-bottom: 5px;
    }
    
    .nav-tabs-modern .nav-item {
        white-space: nowrap;
    }

    .nav-tabs-modern .nav-link {
        padding: 0.8rem 1rem; /* Slightly smaller padding on mobile */
        font-size: 0.9rem;
    }
}

.category-list-scroll {
    font-size: 13px; 
    width: 100%!important; 
    overflow-x: hidden; 
    overflow-y: auto; 
    height: 620px; 
    border-bottom: none;
}
</style>

<div class="row page-titles-modern animate-in">
    <div class="col-md-5 align-self-center">
        <h4 class="text-white">Ajustes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste"><i class="fa fa-home mr-1"></i>Inicio</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste">Restaurante</a></span>
            <span class="breadcrumb-item active">Productos</span>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-3">
        <div class="card card-modern h-100">         
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h4 class="card-title text-primary font-weight-bold"><i class="ti-menu font-18 mr-2"></i> Categorías</h4>
                    <div id="step1">
                         <button type="button" class="btn btn-sm btn-modern btn-modern-success btn-circle btn-categoria-nuevo" style="width: 35px; height: 35px; padding: 0; display: flex; align-items: center; justify-content: center;"><i class="ti-plus"></i></button>
                    </div>
                </div>

                <form id="form-categoria" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id_catg_categoria" id="id_catg_categoria">
                    <div id="display-categoria-nuevo" style="display: none" class="animate-in">
                        <div class="p-3 bg-light rounded mb-3">
                            <div class="row floating-labels m-t-10">
                                <div class="col-sm-12 text-center mb-3">
                                    <div class="ct-wizard-azzure" id="wizardProfile">
                                        <div class="picture-container">
                                            <div class="picture" style="width: 100px; height:100px; margin: 0 auto;">
                                                <img src="<?php echo URL; ?>public/images/productos/default.png" class="picture-src rounded-circle" id="wizardPicturePreview-2" style="width: 100%; height: 100%; object-fit: cover; border: 2px solid var(--primary-color);"/>
                                                <input type="hidden" name="imagen" id="imagen" value="default.png" />
                                                <input type="file" name="imagen" id="wizard-picture-2">
                                            </div>      
                                            <h6 class="mt-2 text-primary pointer">Cambiar Imagen</h6>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group f m-b-20 letNumMayMin">
                                        <input type="text" class="form-control input-mayus cbu ph-0" name="descripcion_categoria" id="descripcion_categoria" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="descripcion_categoria">Nombre</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group m-b-20 ent">
                                        <input type="text" class="form-control input-mayus cbu ph-0" name="orden_categoria" id="orden_categoria" autocomplete="off">
                                        <span class="bar"></span>
                                        <label for="orden_categoria">Orden</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <input type="hidden" name="hidden_estado_categoria" id="hidden_estado_categoria"/>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" name="estado_categoria" id="estado_categoria">
                                        <label class="custom-control-label" for="estado_categoria">Activo</label>
                                    </div>
                                </div>
                                <div class="col-sm-12 mt-2">
                                    <input type="hidden" name="hidden_delivery_categoria" id="hidden_delivery_categoria"/>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" name="delivery_categoria" id="delivery_categoria">
                                        <label class="custom-control-label" for="delivery_categoria">Delivery <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="¿Deseas mostrar esta presentación en tus deliverys?"></i></label>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-3">
                                <div class="col-6">
                                    <a class="btn btn-secondary btn-block btn-categoria-cancelar">Cancelar</a>
                                </div>
                                <div class="col-6">
                                    <button type="submit" class="btn btn-block btn-modern btn-modern-success">Aceptar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
                <ul class="nav nav-tabs sidebar-modern flex-column category-list-scroll" id="ul-cat">
                    <div class="scroll_categoria"></div>
                </ul>
            </div>
        </div>
    </div>
    <div class="col-lg-9">
        <div class="card card-modern h-100">
            <div class="card-body p-0">
                <div class="p-4 border-bottom">
                    <ul class="nav nav-tabs nav-tabs-modern justify-content-center" role="tablist">
                         <li class="nav-item">
                            <a href="producto" class="nav-link active">
                                <i class="mdi mdi-food-fork-drink font-18 mr-2"></i> Platos y bebidas
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="combo" class="nav-link">
                                <i class="mdi mdi-food font-18 mr-2"></i> Combos
                            </a>                        
                        </li>
                        <li class="nav-item">
                            <a href="insumo" class="nav-link">
                                <i class="mdi mdi-food-variant font-18 mr-2"></i> Insumos
                            </a>
                        </li>
                    </ul>
                </div>
                
                <div class="row px-4 floating-labels pt-4">
                    <div class="col-lg-7 p-0">
                        <div class="row p-20">
                            <div class="col-lg-3 mb-3 mb-sm-0">
                                <button class="btn btn-primary btn-block btn-importar-producto btn-modern" id="step2"><i class="ti-upload mr-1"></i> Importar</button>
                            </div>
                            <div class="col-lg-8 mb-3">
                                <button class="btn btn-success btn-block btn-nuevo-producto btn-modern btn-modern-success" id="step2"><i class="fa fa-plus-circle mr-1"></i> Nuevo producto</button>
                            </div>
                            <div class="col-lg-12 m-t-20" id="filter_global">
                                <div class="form-group m-b-0 form-group-modern">
                                    <input class="form-control global_filter" id="global_filter" type="text" placeholder="Buscar producto...">
                                    <span class="bar"></span>
                                    <label for="global_filter"><i class="fa fa-search mr-1"></i> Buscar producto</label>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive b-t m-b-10 table-responsive-modern" style="font-size: 13px; width: 100%!important; overflow-x: hidden; overflow-y: auto; height: 450px">
                            <table class="table table-hover table-modern" width="100%" id="table-productos">
                                <thead>
                                    <th>Producto</th>
                                    <th style="width: 15%; text-align: right">Área</th>
                                    <th style="width: 15%; text-align: right">Transformable</th>
                                    <th style="width: 10%; text-align: right">Activo</th>
                                    <th style="width: 10%;"></th>
                                </thead>
                                <tbody class="tb-st"></tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Column -->
                    <div class="col-lg-5 p-t-20 p-b-20 b-l" style="background: #ffffff;" id="step3">
                        <div id="sinPres">
                            <div class="row text-center align-items-center h-100" style="min-height: 400px;">
                                <div class="col-sm-10 offset-sm-1">
                                    <div style="background: var(--light-bg); padding: 2rem; border-radius: 50%; width: 150px; height: 150px; margin: 0 auto 1.5rem; display: flex; align-items: center; justify-content: center;">
                                        <i class="ti-arrow-circle-left text-primary" style="font-size: 4rem;"></i>
                                    </div>
                                    <h3 class="text-primary font-weight-bold">Seleccione un producto</h3>
                                    <p class="text-muted mt-2">Seleccione un producto de la lista para gestionar sus presentaciones y precios.</p>
                                </div>
                            </div>
                        </div>
                        <div id="conPres" style="display: none" class="animate-in">
                            <div id="head-p" class="mb-3"></div>
                            <div id="body-c"></div>
                            <div class="col-lg-12 m-t-20" id="filter_global">
                                <div class="form-group m-b-0 form-group-modern">
                                    <input class="form-control global_filterPres" id="global_filterPres" type="text" placeholder="Buscar presentación...">
                                    <span class="bar"></span>
                                    <label for="global_filterPres"><i class="fa fa-search mr-1"></i> Buscar presentación</label>
                                </div>
                            </div>
                            <div class="table-responsive b-t m-b-10 mt-3 table-responsive-modern" style="font-size: 13px; width: 100%!important; overflow-x: hidden; overflow-y: auto; height: 400px">
                                <table class="table table-hover table-modern" width="100%" id="table-presentaciones">
                                    <thead>
                                        <th>presentación - Código</th>
                                        <th style="text-align: center">Fav.</th>
                                        <th style="text-align: right">Precio</th>
                                        <th></th>
                                    </thead>
                                    <tbody class="tb-st" id=""></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal parts below remain largely the same logic but could benefit from class updates, keeping them minimal for now to ensure functionality -->
<div class="modal inmodal" id="modal-producto" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog">
        <div class="modal-content animated bounceInTop modal-content-modern">
        <form id="form-producto" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_prod_producto" id="id_prod_producto">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Detalle del producto</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels">
                    <div class="col-md-12">
                        <div class="form-group display-flex">
                            <input class="form-control input-lg input-mayus" type="text" autocomplete="off" placeholder="Nombre" name="nombre_producto" id="nombre_producto" required="required"/>
                            <span class="bar"></span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="btn-group btn-group-toggle btn-group-segments w-100" data-toggle="buttons">
                            <label class="btn btn-outline-secondary active" id="transf" data-original-title="Producto que debes PREPARAR ANTES DE VENDER, Ejm: Ceviches, parrillas o tragos" data-toggle="tooltip" data-placement="top">
                                <input type="radio" name="id_tipo" value="1" autocomplete="off"> Transformado
                            </label>
                            <label class="btn btn-outline-secondary" id="ntransf" data-original-title="Producto que has COMPRADO PARA VENDER, Ejm: Gaseosas, chifles" data-toggle="tooltip" data-placement="top">
                                <input type="radio" name="id_tipo" value="2" autocomplete="off"> No Transformado
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row floating-labels m-t-40">
                    <div class="col-sm-12">
                        <div class="form-group m-b-40">
                            <select class="selectpicker form-control" name="id_areap_producto" id="id_areap_producto" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true" title="Seleccionar" data-size="5" required="required">
                                <?php foreach($this->AreaProduccion as $key => $value): ?>
                                    <option value="<?php echo $value['id_areap']; ?>"><?php echo $value['nombre']; ?></option>
                                <?php endforeach; ?> 
                            </select>
                            <span class="bar"></span>
                            <label for="id_areap_producto">Área de producción <i class="ti-info-alt text-warning font-10" data-original-title="Area donde se elabora el producto" data-toggle="tooltip" data-placement="top"></i></label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40">
                            <input name="notas_producto" id="notas_producto" class="form-control" data-role="tagsinput" placeholder="add">
                            <span class="bar"></span>
                            <label for="notas_producto">Notas <i class="ti-info-alt text-warning font-10" data-original-title="Escribe una o varias notas, Ejm: SIN SAL, POCA SAL" data-toggle="tooltip" data-placement="top"></i></label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40 cbu">
                            <input type="hidden" id="categoria"/>
                            <select class="selectpicker form-control" name="id_catg_producto" id="id_catg_producto" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true" title="Seleccionar" data-size="5" required="required">  
                            </select>
                            <span class="bar"></span>
                            <label for="id_catg_producto">Categoría <i class="ti-info-alt text-warning font-10" data-original-title="Categoría del producto" data-toggle="tooltip" data-placement="top"></i></label>
                        </div>
                    </div>
                    <div class="col-sm-12 m-t-10">
                        <input type="hidden" name="hidden_estado_producto" id="hidden_estado_producto"/>
                         <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" name="estado_producto" id="estado_producto">
                            <label class="custom-control-label" for="estado_producto">Activo</label>
                        </div>
                    </div>
                    <div class="col-sm-12 m-t-10">
                        <input type="hidden" name="hidden_delivery_producto" id="hidden_delivery_producto"/>
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" name="delivery_producto" id="delivery_producto">
                            <label class="custom-control-label" for="delivery_producto">Delivery <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="¿Deseas mostrar esta presentación en tus deliverys?"></i></label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-guardar btn-modern btn-modern-success">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>

<div class="modal inmodal" id="modal-presentacion" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInTop modal-content-modern">
        <form id="form-presentacion" method="post" enctype="multipart/form-data">
        <input type="hidden" name="nombre_producto_presentacion" id="nombre_producto_presentacion">
        <input type="hidden" name="id_prod_presentacion" id="id_prod_presentacion">
        <input type="hidden" name="id_pres_presentacion" id="id_pres_presentacion">
        <!-- Input restored to control visibility of multi-prices tab via JS -->
        <input type="hidden" id="multiples_precios" value="<?php echo Session::get('multiples_precios'); ?>"/>
        <input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>

            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Presentación del producto <span class="nomProductoPres"></span></h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>

            <ul class="nav nav-tabs nav-tabs-modern justify-content-start customtab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" data-toggle="tab" href="#tab1" role="tab" aria-selected="true">Datos de venta</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-toggle="tab" href="#tab2" role="tab" aria-selected="false">Datos de Compra</a>
                </li>
                <li class="nav-item multiples_precios" style="display: none;">
                    <a class="nav-link" data-toggle="tab" href="#tab3" role="tab" aria-selected="false">Precios multiples</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1" role="tabpanel">
                    <div class="modal-body modal-body-modern">
                        <div class="row">
                            <div class="col-sm-5 b-r">
                                <div class="row m-t-20 m-b-20">
                                    <div class="col-sm-12">
                                        <div class="picture-container-modern" id="wizardProfile">
                                            <div class="picture">
                                                <img src="<?php echo URL; ?>public/images/productos/default.png" class="picture-src" id="wizardPicturePreview"/>
                                                <input type="hidden" name="imagen" id="imagen2" value="default.png" />
                                                <input type="file" name="imagen" id="wizard-picture">
                                            </div>      
                                            <h6 class="text-center mt-3 text-primary pointer"><i class="ti-camera mr-1"></i> Cambiar Imagen</h6>
                                        </div>
                                    </div>
                                </div>
                                <div class="row floating-labels">
                                    <div class="col-sm-12 m-t-10 m-b-10 text-center text-danger">
                                        <input type="hidden" name="hidden_favorito" class="text-danger" id="hidden_favorito"/>
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="favorito" id="favorito">
                                            <label class="custom-control-label text-danger font-bold" for="favorito"><i class="fa fa-heart"></i> Favorito</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 m-t-10 m-b-10">
                                        <input type="hidden" name="hidden_estado_presentacion" id="hidden_estado_presentacion"/>
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="estado_presentacion" id="estado_presentacion">
                                            <label class="custom-control-label" for="estado_presentacion">Activo</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 m-t-10 m-b-10" id="tp-1" style="display: none">
                                        <input type="hidden" name="hidden_receta_presentacion" id="hidden_receta_presentacion" value=""/>
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="receta_presentacion" id="receta_presentacion">
                                            <label class="custom-control-label" for="receta_presentacion">Tiene receta <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="¿Esta presentación requiere insumos o productos para su preparación?"></i></label>
                                        </div>
                                    </div>                
                                    <div class="col-sm-6 m-t-10 m-b-10" id="tp-2" style="display: none">
                                        <input type="hidden" name="hidden_stock_presentacion" id="hidden_stock_presentacion"/>
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="stock_presentacion" id="stock_presentacion">
                                            <label class="custom-control-label" for="stock_presentacion">Control Stock <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="¿Esta presentación requiere tener un control de entradas y salidas?"></i></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 m-t-10 m-b-10" id="">
                                        <input type="hidden" name="hidden_impuesto_presentacion" id="hidden_impuesto_presentacion" value=""/>
                                        <input type="hidden" name="igv_impuesto" id="igv_impuesto" value="<?php echo Session::get('igv'); ?>"/>
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="impuesto_presentacion" id="impuesto_presentacion">
                                            <label class="custom-control-label" for="impuesto_presentacion">Impuesto <?php echo Session::get('impAcr'); ?> <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Esta opción te permite trabajar con productos exonerados a impuestos."></i></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 m-t-10 m-b-10">
                                        <input type="hidden" name="hidden_delivery_presentacion" id="hidden_delivery_presentacion"/>
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="delivery_presentacion" id="delivery_presentacion">
                                            <label class="custom-control-label" for="delivery_presentacion">Delivery <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="¿Deseas mostrar esta presentación en tus deliverys?"></i></label>
                                        </div>
                                    </div>
                                    <input type="hidden" name="hidden_impuesto_icbper" id="hidden_impuesto_icbper"/>
                                    <div class="col-sm-6 m-t-10 m-t-0">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="impuesto_icbper" id="impuesto_icbper">
                                            <label class="custom-control-label" for="impuesto_icbper">Impuesto bolsa <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Se activará el impuesto a la bolsa plástica ICBPER"></i></label>
                                        </div>
                                    </div>
                                    <input type="hidden" name="hidden_insumo_principal_presentacion" id="hidden_insumo_principal_presentacion"/>
                                    <?php if(Session::get('opc_02') == 1) { ?>
                                    <div class="col-sm-6 m-t-10 m-t-0">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="insumo_principal_presentacion" id="insumo_principal_presentacion">
                                            <label class="custom-control-label" for="insumo_principal_presentacion">Insumo Princ. <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="¿Esta presentación contiene un insumo principal para su control de entradas y salidas?"></i></label>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="col-sm-7">
                                <div class="row floating-labels">
                                    <div class="col-md-12">
                                        <div class="form-group m-b-40">
                                            <input class="form-control input-lg input-mayus" type="text" autocomplete="off" name="presentacion_presentacion" id="presentacion_presentacion" placeholder="Nombre" required="required"/>
                                            <span class="bar"></span>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group m-b-40">
                                            <textarea name="descripcion_presentacion" id="descripcion_presentacion" class="form-control"></textarea>
                                            <span class="bar"></span>
                                            <label for="descripcion_presentacion">Descripción <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Escribe una descripción breve de la presentación"></i></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group f m-b-40 letNumMayMin">
                                            <input type="text" class="form-control input-mayus cbu" name="cod_prod_presentacion" id="cod_prod_presentacion" autocomplete="off">
                                            <span class="bar"></span>
                                            <label for="cod_prod_presentacion">Código</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group f m-b-40 dec">
                                            <input type="text" class="form-control s" name="precio_presentacion" id="precio_presentacion" autocomplete="off" required>
                                            <span class="bar"></span>
                                            <label for="precio_presentacion">Precio venta - <?php echo Session::get('moneda'); ?></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6" style="display: none">
                                        <div class="form-group f m-b-40 dec">
                                            <input type="text" class="form-control s" name="precio_presentacion2" id="precio_presentacion2" autocomplete="off" value="0.00" required>
                                            <span class="bar"></span>
                                            <label for="precio_presentacion2">Precio venta 2 - <?php echo Session::get('moneda'); ?></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6" id="tp-3" style="display: none">
                                        <div class="form-group f m-b-40 dec">
                                            <input type="text" class="form-control cbu" name="precio_delivery" id="precio_delivery" autocomplete="off">
                                            <span class="bar"></span>
                                            <label for="precio_delivery">Precio delivery - <?php echo Session::get('moneda'); ?></label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6" id="tp-4" style="display: none">
                                        <div class="form-group m-b-40 ent">
                                            <input type="text" name="stock_min_presentacion" id="stock_min_presentacion" class="form-control cbu"autocomplete="off"/>
                                            <span class="bar"></span>
                                            <label for="stock_min_presentacion">Stock mínimo</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6" id="tp-4-1" style="display: none">
                                        <div class="form-group m-b-40 ent">
                                            <input type="hidden" name="hidden_stock_limit" id="hidden_stock_limit"/>
                                             <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" name="stock_limit" id="stock_limit">
                                                <label class="custom-control-label" for="stock_limit">limitar venta <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="¿Deseas limitar venta acorde al stock en tus ventas?"></i></label>
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="col-sm-6" id="tp-4">
                                        <div class="form-group m-b-40 ent">
                                            <input type="text" name="ordenins" id="ordenins" class="form-control cbu"autocomplete="off"/>
                                            <span class="bar"></span>
                                            <label for="stock_min_presentacion">Nº de orden</label>
                                        </div>
                                    </div>
                                </div>
                                <div id="mensaje-ins" style="margin-bottom: 10px"></div> 
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ... (Tab 2 and 3 remain similar but wrapped in modal-body-modern if needed) ... -->
                <div class="tab-pane" id="tab2" role="tabpanel">
                    <br>
                    <div class="modal-body modal-body-modern">
                         <div class="row">
                            <div class="col-sm-12 b-r">
                                <div class="row floating-labels">
                                    <div class="col-sm-6 m-t-10 m-b-10" id="">
                                        <input type="hidden" name="hidden_impuesto_presentacion_compra" id="hidden_impuesto_presentacion_compra" value=""/>
                                        <input type="hidden" name="igv_impuesto" id="igv_impuesto" value="<?php echo Session::get('igv'); ?>"/>
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="impuesto_presentacion_compra" id="impuesto_presentacion_compra">
                                            <label class="custom-control-label" for="impuesto_presentacion_compra">Impuesto <?php echo Session::get('impAcr'); ?> compra</label>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group f m-b-40 dec">
                                            <input type="text" class="form-control s" name="precio_presentacion_compra" id="precio_presentacion_compra" autocomplete="off" required>
                                            <span class="bar"></span>
                                            <label for="precio_presentacion_compra">Precio compra - <?php echo Session::get('moneda'); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane" id="tab3" role="tabpanel">
                    <div class="modal-body modal-body-modern">
                        <div class="row align-items-center">
                            <div class="col-md-5">
                                <div class="form-group form-group-modern m-b-0">
                                    <input class="form-control input-lg input-mayu" type="text" id="nombre" autocomplete="off" placeholder=" ">
                                    <span class="bar"></span>
                                    <label for="nombre">Nombre de la tarifa</label>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="form-group form-group-modern m-b-0">
                                    <input class="form-control s" type="number" id="precio" autocomplete="off" placeholder=" ">
                                    <span class="bar"></span>
                                    <label for="precio">Precio</label>
                                </div>
                            </div>
                            <div class="col-md-2 text-right">
                                <button type="button" class="add-row btn btn-success btn-modern btn-icon">
                                    <i class="fa fa-plus"></i>
                                </button>
                            </div>      
                        </div>

                        <div class="table-responsive mt-4">
                             <table class="table table-hover table-modern tb_precios" width="100%">
                                <thead>
                                    <tr>
                                        <th width="45%" class="font-bold">Nombre</th>
                                        <th width="45%" class="text-right font-bold">Precio</th>
                                        <th width="10%" class="text-center font-bold">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody> </tbody>
                            </table>
                        </div>
                        <div id="procesoGuardarPrecio" style="display: none"></div>
                        <div class="text-right mt-3">
                             <button type="button" class="btn btn-outline-success btn-modern" id="guardar"><i class="fa fa-save mr-1"></i> Guardar precios</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-guaxrdar btn-modern btn-modern-success">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>

<div class="modal long-modal" id="modal-receta" tabindex="-1" role="dialog" aria-labelledby="longmodal" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInTop modal-content-modern">
        <form id="form-receta" method="post" class="form-receta">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Detalle de la receta:  <span class="nomProductoPres"></span></h4>
                    <h2 class="add-ct-btn text-right">
                        <div class="ml-auto">
                            <div class="btn-group">
                            <button type="button" class="btn btn-primary dropdown-toggle btn-modern" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="border: 1px solid white;">
                                <i class="fa fa-download"></i> Descargar receta
                            </button>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <a class="" href="#">
                                        <a class="dropdown-item p-t-0 p-b-0" title="Descargar Excel" id="btnExcel" onclick="exportTableToExcel('TablaReceta')" receta="" style="cursor: pointer;">
                                            <span>
                                                <i class="fa fa-file-excel-o"></i> 
                                                Descargar en excel
                                            </span>
                                        </a>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </h2>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels m-t-0">
                    <div class="col-sm-12">
                        <div class="form-group m-b-0 form-group-modern">
                            <input type="text" name="buscar_ingrediente" id="buscar_ingrediente" class="form-control bg-t" autocomplete="off" placeholder="Búsqueda..."/>
                            <span class="bar"></span>
                             <label for="buscar_ingrediente"><i class="fa fa-search"></i> Buscar Ingrediente</label>
                        </div>
                    </div>
                </div>
            </div>
            <div><hr class="m-t-0 m-b-0"></div>
            <div class="modal-body list-ingredientes px-4 pb-4" style="display: none">
                <div class="card bg-light border-0" style="border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.02);">
                    <div class="card-body p-3">
                        <div class="d-flex align-items-center justify-content-between mb-3">
                            <div>
                                <h5 class="m-0 text-primary font-weight-bold"><i class="ti-shopping-cart mr-2"></i><span id="insumo"></span></h5>
                                <small class="text-muted" style="font-size: 0.8rem;">Detalles del insumo seleccionado</small>
                            </div>
                            <div class="text-right">
                                <span class="badge badge-warning p-2" id="medida" style="font-size: 0.75rem; border-radius: 6px;"></span>
                            </div>
                        </div>

                        <div class="row floating-labels mx-0">
                            <!-- Hidden Fields -->
                            <input type="hidden" name="id_pres_receta" id="id_pres_receta"/>
                            <input type="hidden" name="id_ins_receta" id="id_ins_receta"/>
                            <input type="hidden" name="id_tipo_ins_receta" id="id_tipo_ins_receta"/>

                            <!-- Cantidad -->
                            <div class="col-md-3 pl-0">
                                <div class="form-group mb-0 form-group-modern">
                                    <input type="text" name="cant_receta" id="cant_receta" class="form-control text-center font-weight-bold" autocomplete="off" />
                                    <span class="bar"></span>
                                    <label for="cant_receta">Cantidad</label>
                                </div>
                            </div>

                            <!-- Unidad de Medida -->
                            <div class="col-md-3">
                                <div class="form-group mb-0 form-group-modern">
                                    <select name="id_med_receta" id="id_med_receta" class="selectpicker form-control" data-style="btn-light border-0" data-live-search="true" autocomplete="off" data-size="5">
                                    </select>
                                    <span class="bar"></span>
                                    <label for="id_med_receta">Unidad</label>
                                </div>
                            </div>

                            <!-- Equivalencia -->
                            <div class="col-md-3 d-flex align-items-center justify-content-center bg-white rounded shadow-sm py-2">
                                <small class="text-center text-muted lh-1">
                                    Equivale a:<br>
                                    <strong class="text-dark font-14"><span id="valor_ing">0</span> <span id="desc_medida"></span></strong>
                                </small>
                            </div>

                            <!-- Acciones -->
                            <div class="col-md-3 pr-0 d-flex align-items-center justify-content-end">
                                <div class="custom-control custom-checkbox mr-3">
                                    <input type="checkbox" class="custom-control-input" id="checkbox_principal" name="checkbox_principal">
                                    <label class="custom-control-label font-12" for="checkbox_principal">Principal</label>
                                </div>
                                <div>
                                    <button type="submit" class="btn btn-success btn-circle btn-modern shadow-sm mr-1"><i class="ti-plus"></i></button>
                                    <button type="button" class="btn btn-danger btn-circle btn-eliminar btn-modern shadow-sm"><i class="ti-trash"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Separator optional or removed -->
        </form>
            <div class="modal-body modal-lg p-0">
                <div class="table-responsive scroll_rseceta" style="overflow-y:auto; height:400px;">
                    <table id="TablaReceta" class="table table-hover table-modern m-0" width="100%">
                        <thead class="table-head">
                            <tr>
                                <th class="text-center border-0">Tipo</th>
                                <th class="text-center border-0">Categoría</th>
                                <th class="text-center border-0">Nombre</th>
                                <th class="text-center border-0">Cantidad</th>
                                <th class="text-center border-0">Unidad <br> Medida</th>
                                <th class="text-center border-0">Costo <br> Unitario</th>
                                <th class="text-center border-0">Costo <br> total</th>
                                <th class="text-center border-0">Principal</th>
                                <th class="text-right border-0">Acciones</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st" id="table-receta"></tbody>
                        <tfoot class="bg-light">
                            <tr>
                                <th colspan="3" class="text-right border-top-0">Total Items</th>
                                <th colspan="2" id="total_items" class="text-left font-weight-bold border-top-0">0</th>
                                <th colspan="2" class="text-right border-top-0">Total Costo receta</th>
                                <th id="total_receta" class="font-weight-bold text-success border-top-0">0.00</th>
                                <th colspan="2" class="border-top-0"></th>
                            </tr>
                        </tfoot>
                    </table>   
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-modern btn-secondary px-4" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<!-- modal import -->

<div class="modal inmodal" id="modal-import" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content animated bounceInTop modal-content-modern">
        <form id="form-import" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_prod_producto" id="id_prod_producto">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Propiedades de Importación</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels">
                    <div class="col-md-12 mb-3">
                        <span class="text-muted">
                            Seleccione un archivo Excel (.xlsx) para importar productos masivamente:
                        </span>
                    </div>                    
                </div>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <div id="yourBtn" onclick="getFile()" class="d-flex align-items-center justify-content-center flex-column p-4 border rounded bg-white shadow-sm" style="border-style: dashed !important; border-color: #cbd5e0 !important; cursor: pointer; transition: all 0.3s;">
                            <i class="ti-cloud-up text-primary mb-2" style="font-size: 2rem;"></i>
                            <span class="font-weight-bold text-primary">Seleccionar archivo</span>
                            <small class="text-muted mt-1">Haga clic aquí</small>
                        </div>
                        <div style='height: 0px;width: 0px; overflow:hidden;'>
                        <!-- type="file" name="name"  id="name" -->
                            <input id="upfile" type="file" value="upload" onchange="sub(this) " accept=".xls,.xlsx" />
                        </div>
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-12 text-center">
                    <a class="btn btn-outline-info btn-sm btn-modern" href="<?php echo URL; ?>/public/excel/productos.xlsx"><i class="fa fa-download mr-1"></i> Descargar plantilla de ejemplo</a>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary btn-modern" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-guardar btn-modern btn-modern-success">Importar Productos</button>
            </div>
        </form>
        </div>
    </div>
</div>

<!--fin -->
<style>
/* Modern jQuery UI Autocomplete */
.ui-autocomplete {
    background: white !important;
    border: none !important;
    border-radius: 12px !important;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15) !important;
    padding: 10px !important;
    font-family: 'Poppins', sans-serif !important;
    max-height: 300px;
    overflow-y: auto;
    z-index: 9999 !important; /* Ensure it's above modal */
}

.ui-menu-item {
    border-radius: 8px;
    margin-bottom: 2px;
    transition: all 0.2s;
    list-style: none;
}

.ui-menu-item-wrapper {
    padding: 10px 15px !important;
    font-size: 0.9rem !important;
    color: #495057 !important;
    border: none !important;
    background: transparent !important;
    display: block; 
    cursor: pointer;
}

.ui-state-active,
.ui-widget-content .ui-state-active,
.ui-widget-header .ui-state-active,
a.ui-button:active,
.ui-menu-item-wrapper:hover {
    border: none !important;
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%) !important;
    color: white !important;
    font-weight: 500 !important;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.ui-helper-hidden-accessible {
    display: none;
}

/* Modal Import Button Styles */
#yourBtn:hover {
    background-color: #f8f9fa !important;
    border-color: var(--primary-color) !important;
    transform: translateY(-2px);
}
</style>
<script type="text/javascript">
function getFile() {
  document.getElementById("upfile").click();
}

function sub(obj) {
  var file = obj.value;
  var fileName = file.split("\\");
  document.getElementById("yourBtn").innerHTML = '<i class="ti-file text-success mb-2" style="font-size: 2rem;"></i><span class="font-weight-bold text-success">' + fileName[fileName.length - 1] + '</span>';
  // document.myForm.submit(); // Removed auto submit to let user choose
  // event.preventDefault();
}



$(function() {
    $('#config').addClass("active");
    function filterGlobal () {
    $('#table-productos').DataTable().search( 
        $('#global_filter').val()
    ).draw();
    }
    $('input.global_filter').on( 'keyup click', function () {
        filterGlobal();
    } );
});
$(function() {
    $('#config').addClass("active");
    function filterGlobalPres () {
    $('#table-presentaciones').DataTable().search( 
    $('#global_filterPres').val()
).draw();
    }
    $('input.global_filterPres').on('keyup click', function () {
    filterGlobalPres();
} );
});
</script>
