<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MODERN === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: var(--transition);
}

.card-modern:hover {
    box-shadow: var(--card-shadow-hover);
}

/* === BUTTONS MODERN === */
.btn-modern {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.6rem 1.2rem;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-1px);
    box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
}

.btn-modern-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, var(--success-color) 0%, #2ecc71 100%);
    color: white;
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}

/* === PROFILE PICTURE MODERN === */
.picture-container-modern {
    position: relative;
    cursor: pointer;
    text-align: center;
    transition: all 0.3s ease;
}
.picture-container-modern .picture {
    width: 150px;
    height: 150px;
    background-color: #f8f9fa;
    border: 2px dashed #dce2e6; /* Dashed - Dropzone feel */
    color: #adb5bd;
    border-radius: 50%;
    margin: 0px auto;
    overflow: hidden;
    transition: all 0.3s;
    position: relative;
    display: flex;
    justify-content: center;
    align-items: center;
}
.picture-container-modern:hover .picture {
    border-color: var(--primary-color);
    box-shadow: 0 5px 15px rgba(86, 100, 210, 0.2);
    transform: scale(1.02);
}
.picture-container-modern input[type="file"] {
    cursor: pointer;
    display: block;
    height: 100%;
    left: 0;
    opacity: 0 !important;
    position: absolute;
    top: 0;
    width: 100%;
}
.picture-src {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* === FORMULARIO MODERN === */
.form-group-modern {
    position: relative;
    margin-bottom: 25px;
}

.form-group-modern input.form-control,
.form-group-modern select.form-control,
.form-group-modern textarea.form-control {
    border: none;
    border-bottom: 2px solid #e9ecef;
    border-radius: 0;
    padding: 10px 0;
    background: transparent;
    font-weight: 500;
    transition: all 0.3s;
    box-shadow: none;
}

.form-group-modern .bootstrap-select > .dropdown-toggle {
    border: none;
    border-bottom: 2px solid #e9ecef;
    background: transparent !important;
    box-shadow: none !important;
    padding: 10px 0;
    border-radius: 0;
}

.form-group-modern input.form-control:focus,
.form-group-modern select.form-control:focus,
.form-group-modern textarea.form-control:focus,
.form-group-modern .filter-option {
    border-bottom-color: var(--primary-color);
}

.form-group-modern label {
    color: #adb5bd;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    transition: all 0.3s;
    margin-bottom: 5px;
    display: block;
}

.form-group-modern input:focus ~ label,
.form-group-modern input:valid ~ label,
.form-group-modern textarea:focus ~ label,
.form-group-modern textarea:valid ~ label {
    color: var(--primary-color);
    font-weight: 600;
}

/* Switch Polish */
.switch label input[type=checkbox]:checked + .lever {
    background-color: #aeb5ea; /* Lighter primary */
}
.switch label input[type=checkbox]:checked + .lever:after {
    background-color: var(--primary-color);
    left: 24px;
}
.switch label .lever {
    width: 50px;
    height: 24px;
    margin: 0;
    background-color: #e9ecef;
    border-radius: 24px;
}
.switch label .lever:after {
    width: 18px;
    height: 18px;
    background-color: #adb5bd;
    border-radius: 50%;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    top: 3px;
    left: 4px;
    transition: all 0.3s ease;
}
</style>

<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("h:i A");
$fechaa = date("07:00");
?>
<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<div class="row page-titles-modern animate-in">
    <div class="col-md-5 align-self-center">
        <h4 class="text-white">Ajustes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste"><i class="fa fa-home mr-1"></i>Inicio</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste">Empresa</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste/usuario">Usuarios</a></span>
            <li class="breadcrumb-item active">Edición</li>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card card-modern">
            <form id="form" method="post" enctype="multipart/form-data">
            <input type="hidden" name="id_usu" id="id_usu" value="<?php echo $r = (isset($this->usuario['id_usu'])) ? $this->usuario['id_usu'] : ''; ?>"/>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 text-center">
                         <div class="picture-container-modern mt-4" id="wizardProfile">
                            <div class="picture">
                            <?php if ($this->usuario['id_usu'] != null ) { ?> 
                                <img src="<?php echo URL; ?>public/images/users/<?php echo $this->usuario['imagen']; ?>" class="picture-src" id="wizardPicturePreview" title=""/>
                                <input type="hidden" name="imagen" id="imagen" value="<?php echo $this->usuario['imagen']; ?>"/>
                                <input type="file" name="imagen" id="wizard-picture">
                            <?php } else { ?>
                                <img src="<?php echo URL; ?>public/images/users/default-avatar.png" class="picture-src" id="wizardPicturePreview" title=""/>
                                <input type="hidden" name="imagen" id="imagen" value="default-avatar.png" />
                                <input type="file" name="imagen" id="wizard-picture">
                            <?php } ?>
                            </div>      
                            <h6 class="mt-3 font-weight-bold text-primary"><i class="fa fa-camera mr-1"></i> Cambiar Imagen</h6>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <h4 class="card-title text-primary font-weight-bold mb-4 border-bottom pb-2">Información del Usuario</h4>
                        <div class="row floating-labels pr-4">
                            <div class="col-md-6">
                                <div class="form-group ent m-b-40 form-group-modern">
                                    <input type="text" class="form-control" name="dni" id="dni" value="<?php echo $r = (isset($this->usuario['dni'])) ? $this->usuario['dni'] : ''; ?>" autocomplete="off" minlength="<?php echo Session::get('diCar'); ?>" maxlength="<?php echo Session::get('diCar'); ?>" required="required"/>
                                    <span class="bar"></span>
                                    <label for="dni" class="c-dni"><?php echo Session::get('diAcr'); ?></label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group letMayMin m-b-40 form-group-modern">
                                    <input type="text" class="form-control input-mayus" name="nombres" id="nombres" value="<?php echo $r = (isset($this->usuario['nombres'])) ? $this->usuario['nombres'] : ''; ?>" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="nombres">Nombres</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group letMayMin m-b-40 form-group-modern">
                                    <input type="text" class="form-control input-mayus" name="ape_paterno" id="ape_paterno" value="<?php echo $r = (isset($this->usuario['ape_paterno'])) ? $this->usuario['ape_paterno'] : ''; ?>" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="ape_paterno">Apellido Paterno</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group letMayMin m-b-40 form-group-modern">
                                    <input type="text" class="form-control input-mayus" name="ape_materno" id="ape_materno" value="<?php echo $r = (isset($this->usuario['ape_materno'])) ? $this->usuario['ape_materno'] : ''; ?>" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="ape_materno">Apellido Materno</label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group m-b-40 form-group-modern">
                                    <input type="text" class="form-control" name="email" id="email" value="<?php echo $r = (isset($this->usuario['email'])) ? $this->usuario['email'] : ''; ?>" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="email">Email</label>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group m-b-40 form-group-modern">
                                    <select class="selectpicker form-control" name="id_rol" id="id_rol" data-style="form-control btn-default" title="Seleccionar" data-live-search-style="begins" data-live-search="true" required="required">
                                        <?php foreach($this->Rol as $key => $value): ?>
                                            <option value="<?php echo $value['id_rol']; ?>"><?php echo $value['descripcion']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="bar"></span>
                                    <label for="id_rol">Cargo</label>
                                </div>
                                <input type="hidden" id="cod_rol" value="<?php echo $r = (isset($this->usuario['id_rol'])) ? $this->usuario['id_rol'] : ''; ?>">
                            </div>
                            <div class="col-sm-12" id="col-areap" style="display: none">
                                <div class="form-group m-b-40 form-group-modern">
                                    <select class="selectpicker form-control" name="id_areap" id="id_areap" data-style="form-control btn-default" title="Seleccionar" data-live-search-style="begins" data-live-search="true" required>
                                        <?php foreach($this->AreaProduccion as $key => $value): ?>
                                            <option value="<?php echo $value['id_areap']; ?>"><?php echo $value['nombre']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <span class="bar"></span>
                                    <label for="id_areap">&Aacute;rea de Producci&oacute;n</label>
                                </div>
                                <input type="hidden" id="cod_area" value="<?php echo $r = (isset($this->usuario['id_areap'])) ? $this->usuario['id_areap'] : ''; ?>">
                            </div>
                            <div class="col-md-6">
                                <div class="form-group letNumMayMin m-b-40 form-group-modern">
                                    <input type="text" class="form-control" name="usuario" id="usuario" value="<?php echo $r = (isset($this->usuario['usuario'])) ? $this->usuario['usuario'] : ''; ?>" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="usuario">Usuario</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group m-b-40 form-group-modern">
                                    <input type="password" class="form-control" name="contrasena" id="contrasena" value="<?php echo $r = (isset($this->usuario['contrasena'])) ? base64_decode($this->usuario['contrasena']) : ''; ?>" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="contrasena">Contrase&ntilde;a</label>
                                </div>
                            </div>
                            <div class="col-sm-6 text-left">
                                <div class="switch">
                                    <label>
                                        <input type="checkbox" name="editarprecio" id="editarprecio" class="chk-col-green" />
                                        <span class="lever switch-col-light-green"></span> Editar precio en venta
                                    </label>
                                </div>
                            </div>
                            <div class="col-sm-6 text-left " id="horario_s" style="display: none">
                                <div class="switch">
                                    <label>
                                        <input type="checkbox" name="horario" id="horario" class="chk-col-red horario" />
                                        <span class="lever switch-col-light-green"></span> Registrar horario
                                    </label>
                                </div>
                            </div>
                            <div class="col-lg-6 display_horario" style="display: none;">
                                <div class="form-group m-b-40 form-group-modern">
                                    <div class="input-group">
                                        <input type="text" class="form-control font-14 text-center" name="start" id="start" value="<?php echo $r = (isset($this->usuario['turno_ing'])) ? date('h:i A',strtotime($this->usuario['turno_ing'])) : $fechaa.' AM'; ?>" autocomplete="off"/>
                                        <span class="input-group-text bg-gris">al</span>
                                        <input type="text" class="form-control font-14 text-center" name="end" id="end" value="<?php echo $r = (isset($this->usuario['turno_sal'])) ? date('h:i A',strtotime($this->usuario['turno_sal'])) : $fecha; ?>" autocomplete="off"/>
                                    </div>
                                    <label>Rango de horario</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer bg-white border-top-0">
                <div class="text-right">
                    <a href="<?php echo URL; ?>ajuste/usuario" class="btn btn-secondary btn-modern">Cancelar</a>
                    <button class="btn btn-success btn-modern btn-modern-success" type="submit">Aceptar</button>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>
<script>
    <?php if($this->usuario['editarprecio'] == "1" ){ ?>
    $('#editarprecio').prop('checked', true);
    <?php }

    if(isset($this->usuario['turno_ing']) ){ ?>
    $('.horario').prop('checked', true);
    $('.display_horario').css('display','block');
    $('#horario_s').css('display','block');
    <?php }else{ ?>
        $(function() {
            $("#start").prop('disabled', true);
            $("#end").prop('disabled', true);
        });      

    <?php } ?>
</script> 