var moneda = $("#moneda").val();
$(function() {
    listar(1);
    $('#clientes').addClass("active");
    $('#form').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
            dni: {
                validators: {
                    stringLength: {
                        message: 'El '+$(".c-dni").text()+' debe tener '+$("#dni").attr("maxlength")+' digitos'
                    }
                }
            },
            ruc: {
                validators: {
                    stringLength: {
                        message: 'El '+$(".c-ruc").text()+' debe tener '+$("#ruc").attr("maxlength")+' digitos'
                    }
                }
            }
        }
    })
    .on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');

        var parametros = {
            "id_cliente" : $("input[name='id_cliente']").val(),
            "tipo_cliente" : $("input[name='tipo_cliente']").val(),
            "dni" : $("input[name='dni']").val(),
            "ruc" : $("input[name='ruc']").val(),
            "nombres" : $("input[name='nombres']").val(),
            "fecha_nac" : $("input[name='fecha_nac']").val(),
            "telefono" : $("input[name='telefono']").val(),
            "correo" : $("input[name='correo']").val(),
            "razon_social" : $("input[name='razon_social']").val(),
            "direccion" : $("input[name='direccion']").val(),
            "referencia" : $("input[name='referencia']").val()
        };

        if($("input[name='id_cliente']").val() != ''){
            var text = 'actualizará';
        } else{
            var text = 'registrará';
        }

        var html_confirm = '<div>Se '+text+' los datos del cliente:<br> '+$("input[name='razon_social']").val()+''+$("input[name='nombres']").val()+'</div><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

        Swal.fire({
            title: 'Necesitamos de tu Confirmación',
            html: html_confirm,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#34d16e',
            confirmButtonText: 'Si, Adelante!',
            cancelButtonText: "No!",
            showLoaderOnConfirm: true,
            preConfirm: function() {
              return new Promise(function(resolve) {
                 $.ajax({
                    url: $('#url').val()+'cliente/cliente_crud',
                    type: 'POST',
                    data: parametros,
                    dataType: 'json'
                 })
                 .done(function(response){
                    $('#modal').modal('hide');
                    if(response==1){
                        var title = 'Proceso Terminado';
                        var text = 'Datos registrados correctamente';
                        var type = 'success';
                        listar($('#filtro_tipo_cliente').val());
                    }else if(response==2){
                        var title = 'Proceso Terminado';
                        var text = 'Datos actualizados correctamente';
                        var type = 'success';
                        listar($('#filtro_tipo_cliente').val());
                    }else if(response==0){
                        var title = 'Proceso No Culminado';
                        var text = 'Datos duplicados';
                        var type = 'error';                        
                    }
                    Swal.fire({
                        title: title,
                        text: text,
                        icon: type,
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });               
                    listar($('#filtro_tipo_cliente').val());
                    resetViews();
                 })
                 .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                 });
              });
            },
            allowOutsideClick: false              
        });  
    });
});

$('.list-personas').click( function() {
    $('#filtro_tipo_cliente').val('1');
    resetViews();
    listar(1);
});

$('.list-empresas').click( function() {
    $('#filtro_tipo_cliente').val('2');
    resetViews();
    listar(2);
});

// Helper to reset views to initial state
var resetViews = function() {
    $('.display-one').removeClass('d-none').addClass('d-flex');
    $('.display-two').addClass('d-none').removeClass('d-block');
}

// Helper to show details
var showDetails = function() {
    $('.display-one').removeClass('d-flex').addClass('d-none');
    $('.display-two').removeClass('d-none').addClass('d-block');
}

var listar = function(tipo_cliente){

    //tipo_cliente = $('#filtro_tipo_cliente').selectpicker('val');
    function filterGlobal () {
        $('#table').DataTable().search( 
            $('#global_filter').val()
        ).draw();
    }

    var table = $('#table')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"cliente/cliente_list",
            "data": {
                tipo_cliente: tipo_cliente
            }
        },        
        "columns":[
            {
                "data":null,
                "render": function ( data, type, row ) {
                var tipo = (data.tipo_cliente == 1) ? $('#diAcr').val() : $('#tribAcr').val();
                // Escape quotes in name to prevent JS errors
                var safeName = data.nombre.replace(/'/g, "\\'").replace(/"/g, '&quot;');
                return '<div style="cursor: pointer;" onclick="venta_list('+data.id_cliente+',\''+safeName+'\');">' + 
                       '<h6 class="mb-0 font-weight-bold text-primary">' + data.nombre + '</h6>' + 
                       '<small class="text-muted font-12"><span class="font-weight-medium">'+tipo+':</span> '+data.dni+''+data.ruc+'</small></div>';
            }},
            {"data":null,"render": function ( data, type, row ) {
                var safeName = data.nombre.replace(/'/g, "\\'").replace(/"/g, '&quot;');
                if(data.estado == 'a'){
                    return '<div class="text-center"><a href="javascript:void(0)" onclick="estado('+data.id_cliente+',\''+data.estado+'\',\''+safeName+'\''+');"><span class="badge badge-success px-2 py-1">ACTIVO</span></a></div>';
                }else if(data.estado == 'i'){
                    return '<div class="text-center"><a href="javascript:void(0)" onclick="estado('+data.id_cliente+',\''+data.estado+'\',\''+safeName+'\''+');"><span class="badge badge-secondary px-2 py-1">INACTIVO</span></a></div>';
                }
            }},
            {"data":null,"render": function ( data, type, row ) {
                var safeName = data.nombre.replace(/'/g, "\\'").replace(/"/g, '&quot;');
                return '<div class="text-center"><button class="btn btn-sm btn-outline-info border-0" onclick="editar('+data.id_cliente+');"><i data-feather="edit" class="feather-sm"></i></button>'
                    +'&nbsp;<button class="btn btn-sm btn-outline-danger border-0" onclick="anular('+data.id_cliente+',\''+safeName+'\''+');"><i data-feather="trash-2" class="feather-sm"></i></button></div>';
            }}
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.clientes-total').text(total);
        },
        "drawCallback": function( settings ) {
            feather.replace();
        }
    });
    
    $('input.global_filter').on( 'keyup click', function () {
        filterGlobal();
    });
};

var venta_list = function(id_cliente,nombre_cliente){
    showDetails();
    $('.cliente-nombre').text(nombre_cliente);
    var count = 1;
    var table = $('#table-ventas')
    .DataTable({
        "destroy": true,
        "dom": "tp",
        "bSort": true,
        "order": [[0,"desc"]],
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"cliente/cliente_ventas",
            "data": {
                id_cliente: id_cliente
            }
        },
        "columns":[
            {"data":"fec_ven","render": function ( data, type, row ) {
                return '<i class="fas fa-calendar-alt mr-1"></i> '+moment(data).format('DD-MM-Y')
                +'<br><span class="font-12 text-muted ml-3"><i class="fas fa-clock mr-1"></i> '+moment(data).format('h:mm A')+'</span>';
            }},
            {"data":null,"render": function ( data, type, row ) {
                return '<span class="font-weight-medium">' + data.desc_td + '</span>'
                +'<br><span class="font-12 text-muted">'+data.ser_doc+'-'+data.nro_doc+'</span>';
            }},
            {"data":"monto_total","render": function ( data, type, row ) {
                return '<div class="text-right font-weight-bold text-dark">'+formatNumber(data)+'</div>';
            }}
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };

            // Calculate discount (if column exists, previously index 2, now removed or changed?)
            // NOTE: In the previous HTML, table-ventas had 3 columns (Fecha, Documento, Total).
            // But JS logic references index 2 as Discount and 3 as Total. 
            // In my new definition I only have 3 columns total. So Total is index 2.
            // I will assume Discount is NOT shown in table but I still need to calculate it?
            // Actually the previous JS had 4 columns. 
            // My new HTML has 3 columns.
            // Let's adjust logic.
            
            // Wait, the API returns data. We can sum raw data instead of column data if needed, 
            // BUT api.column().data() is convenient.
            // Let's check headers in HTML: 
            // <tr> <th>Fecha</th> <th>Documento</th> <th class="text-right">Total</th> </tr>
            // So logic needs to change.

            // Sum Total (Index 2 in new table)
            total = api
                .column( 2 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
            
            // If I can't access discount column because it's hidden/removed, I simply won't show it 
            // OR I should use rows().data() to iterate objects.
            
            var totalDescuento = 0;
            api.rows().data().each(function(val) {
                // Assuming val.desc_monto exists available in JSON even if not in table
                 if(val.desc_monto) totalDescuento += intVal(val.desc_monto);
            });

            operaciones = api
                .rows()
                .data()
                .count();

            $('.ventas-total').text(moneda+' '+formatNumber(total));
            $('.ventas-descuentos').text(moneda+' '+formatNumber(totalDescuento));
            $('.ventas-operaciones').text(operaciones);
        }
    });
    $('.dataTables_wrapper').addClass('p-0');
}

/* Estado del cliente Activo - Inactivo */
var estado = function(id_cliente,estado,nombres){

    if(estado == 'a'){
        var esta = 'INACTIVO';
        var est = 'i';
        var confirmColor = '#e74c3c';
    }else{
        var esta = 'ACTIVO';
        var est = 'a';
        var confirmColor = '#34d16e';
    }

    var html_confirm = '<div>Se pondrá '+esta+' al cliente:<br> <b>'+nombres+'</b></div><br>\
        <div><span class="" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

    Swal.fire({
        title: 'Confirmación',
        html: html_confirm,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: confirmColor,
        confirmButtonText: 'Sí, cambiar',
        cancelButtonText: "Cancelar",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                $.ajax({
                    url: $('#url').val()+'cliente/cliente_estado',
                    type: 'POST',
                    data: {
                        id_cliente: id_cliente,
                        estado: est
                    },
                    dataType: 'json'
                })
                .done(function(response){
                    Swal.fire({
                        title: 'Actualizado',
                        text: 'El estado ha sido cambiado correctamente',
                        icon: 'success',
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });
                    listar($('#filtro_tipo_cliente').val());
                    resetViews();
                })
                .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                });
            });
        },
        allowOutsideClick: false              
    });
}

var anular = function(id_cliente,nombres){

    var html_confirm = '<div>Se eliminará al cliente:<br> <b>'+nombres+'</b></div><br>\
        <div><span class="text-danger" style="font-size: 17px;">¿Está seguro de esta acción?</span></div>';

    Swal.fire({
        title: 'Eliminar Cliente',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#e74c3c',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: "Cancelar",
        showLoaderOnConfirm: true,
        preConfirm: function() {
          return new Promise(function(resolve) {
             $.ajax({
                url: $('#url').val()+'cliente/cliente_delete',
                type: 'POST',
                data: {id_cliente: id_cliente},
                dataType: 'json'
             })
             .done(function(response){
                if(response == 1){
                Swal.fire({
                    title: 'Eliminado',
                    text: 'Cliente eliminado correctamente',
                    icon: 'success',
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar"
                });
                }else{
                    Swal.fire({
                        title: 'No se puede eliminar',
                        text: 'Este cliente tiene ventas registradas o datos protegidos.',
                        icon: 'error',
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });
                }
                listar($('#filtro_tipo_cliente').val());
                resetViews();
             })
             .fail(function(){
                Swal.fire('Error', 'Problemas con la conexión', 'error');
             });
          });
        },
        allowOutsideClick: false              
    });
}

var editar = function(id_cliente){
    $.ajax({
        url: $('#url').val()+'cliente/cliente_datos',
        type: 'POST',
        data: {id_cliente: id_cliente},
        dataType: 'json'
    })
    .done(function(item){
        $.each(item.data, function(i, campo) {
            $('#id_cliente').val(campo.id_cliente);
            $('#tipo_cliente').val(campo.tipo_cliente);
            $('#dni').val(campo.dni);
            $('#ruc').val(campo.ruc);
            $('#nombres').val(campo.nombres);
            $('#ape_paterno').val(campo.ape_paterno);
            $('#ape_materno').val(campo.ape_materno);
            $('#fecha_nac').val(moment(campo.fecha_nac).format('DD-MM-Y'));
            $('#telefono').val(campo.telefono);
            $('#correo').val(campo.correo);
            $('#razon_social').val(campo.razon_social);
            $('#direccion').val(campo.direccion);
            $('#referencia').val(campo.referencia);
            $('.modal-title').text('Editar Cliente');
            if(campo.tipo_cliente == 1){
                $("#td_dni").click();
            } else if(campo.tipo_cliente == 2){
                $("#td_ruc").click();
            }
        });
        $('#modal').modal('show');
    })
    .fail(function(){
        Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
    });
}

$('.btn-nuevo').click( function() {
    $('#id_cliente').val('');
    $('#tipo_cliente').val(1);
    $('.modal-title').text('Nuevo Cliente');
    $('#modal').modal('show');
    $("#td_dni").click(); // Trigger click to set defaults
});

$('input:radio[id=td_dni]').on('click', function(event){
    $('#tipo_cliente').val(1);
    $("#td_dni").prop('checked', true);
    $(".block01").show();
    $(".block02").hide();
    $(".block03").show();
    $(".block04").show();
    $(".block05").show();
    $(".block06").show();
    $(".block07").hide();
    $(".dni").prop('disabled', false);
    $(".ruc").prop('disabled', true);
    $('#form').formValidation('resetForm', true);
});

$('input:radio[id=td_ruc]').on('click', function(event){
    $('#tipo_cliente').val(2);
    $("#td_ruc").prop('checked', true);
    $(".block01").hide();
    $(".block02").show();
    $(".block03").hide();
    $(".block04").hide();
    $(".block05").hide();
    $(".block06").hide();
    $(".block07").show();
    $(".dni").prop('disabled', true);
    $(".ruc").prop('disabled', false);
    $('#form').formValidation('resetForm', true);
});

$('#modal').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#form').formValidation('resetForm', true);
});

/* Consultar dni del nuevo cliente */
$("#dni").keyup(function(event) {
    var that = this,
    value = $(this).val();
    if (value.length == $("#dni").attr("maxlength")) {
        $.getJSON($('#url').val()+"api/dni/"+$("#dni").val(), {
            format: "json"
        })
        .done(function(data) {
            $("#dni").val(data.dni);
            $("#nombres").val(data.nombres+' '+data.apellidoPaterno+' '+data.apellidoMaterno);
            $("#fecha_nac").val(data.fechaNacimiento);
            $("#direccion").val(data.direccion);
            $('#form').formValidation('revalidateField', 'nombres');
            $('#form').formValidation('revalidateField', 'ape_paterno');
            $('#form').formValidation('revalidateField', 'ape_materno');
        });
    }
});

/* Consultar ruc del nuevo cliente */
$("#ruc").keyup(function(event) {
    var that = this,
    value = $(this).val();
    if (value.length == $("#ruc").attr("maxlength")) {
        $.getJSON($('#url').val()+"api/ruc/"+$("#ruc").val(), {
            format: "json"
        })
        .done(function(data) {
            $("#ruc").val(data.ruc);
            $("#razon_social").val(data.razonSocial);
            $("#direccion").val(data.direccion);
            $('#form').formValidation('revalidateField', 'razon_social');
            $('#form').formValidation('revalidateField', 'direccion');
        });
    }
});