<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 4px 20px rgba(0,0,0,0.05);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === CATEGORY CARDS === */
.category-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    border: 1px solid #f0f0f0;
    box-shadow: var(--card-shadow);
    transition: var(--transition);
    cursor: pointer;
    text-align: center;
    height: 100%;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    position: relative;
    overflow: hidden;
}

.category-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    border-color: var(--primary-color);
}

.category-card.active-cat {
    background: #f0f7ff;
    border-color: var(--primary-color);
}

.cat-icon-wrapper {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    margin-bottom: 1rem;
    background: #f8f9fa;
    transition: var(--transition);
}

.category-card:hover .cat-icon-wrapper {
    background: var(--primary-color);
    color: white !important;
}

.cat-title {
    font-weight: 700;
    color: #333;
    font-size: 1.1rem;
    margin-bottom: 0.5rem;
}

.cat-desc {
    color: #8898aa;
    font-size: 0.85rem;
    line-height: 1.4;
}

/* === SUB-REPORT PANEL === */
.sub-report-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    border: none;
    min-height: 300px;
}

.sub-report-header {
    background: #fff;
    border-bottom: 1px solid #f0f0f0;
    padding: 1.5rem;
    border-radius: var(--border-radius) var(--border-radius) 0 0;
}

.empty-state {
    text-align: center;
    padding: 3rem;
    color: #8898aa;
}
.empty-state i { font-size: 3rem; margin-bottom: 1rem; color: #cbd5e0; }

/* === LIST GROUP MODERN === */
.list-group-modern .list-group-item {
    border: none;
    border-bottom: 1px solid #f0f0f0;
    padding: 1rem 1.5rem;
    font-size: 0.95rem;
    color: #555;
    transition: var(--transition);
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.list-group-modern .list-group-item:hover {
    background-color: #f8f9fa;
    color: var(--primary-color);
    padding-left: 2rem;
}

.list-group-modern .list-group-item i.arrow {
    opacity: 0;
    transition: var(--transition);
}
.list-group-modern .list-group-item:hover i.arrow {
    opacity: 1;
}

.animate-in { animation: fadeInUp 0.6s ease; }
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <div>
        <h4><i class="fas fa-chart-pie mr-2"></i>Centro de Informes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Inicio</span>
            <span class="breadcrumb-item active">Panel de Opciones</span>
        </div>
    </div>
</div>

<div class="wrapper wrapper-content animated fadeIn">
    <div class="row">
        <!-- LEFT COLUMN: CATEGORIES -->
        <div class="col-lg-5 mb-4">
            <!-- Grid for Mobile: 2 Columns -->
            <div class="row">
                <!-- Ventas -->
                <div class="col-6 mb-3">
                    <div class="category-card ventas animate-in" style="animation-delay: 0.1s;">
                        <div class="cat-icon-wrapper text-success">
                            <i class="fas fa-shopping-cart"></i>
                        </div>
                        <h5 class="cat-title">Ventas</h5>
                        <p class="cat-desc d-none d-md-block">Reportes de ingresos por ventas y facturación.</p>
                    </div>
                </div>
                <!-- Compras -->
                <div class="col-6 mb-3">
                    <div class="category-card compras animate-in" style="animation-delay: 0.2s;">
                        <div class="cat-icon-wrapper text-primary">
                            <i class="fas fa-shopping-bag"></i>
                        </div>
                        <h5 class="cat-title">Compras</h5>
                        <p class="cat-desc d-none d-md-block">Historial de gastos y proveedores.</p>
                    </div>
                </div>
                <!-- Finanzas -->
                <div class="col-6 mb-3">
                    <div class="category-card finanzas animate-in" style="animation-delay: 0.3s;">
                        <div class="cat-icon-wrapper text-warning">
                            <i class="fas fa-hand-holding-usd"></i>
                        </div>
                        <h5 class="cat-title">Finanzas</h5>
                        <p class="cat-desc d-none d-md-block">Flujo de caja, ingresos y egresos.</p>
                    </div>
                </div>
                <!-- Inventario -->
                <div class="col-6 mb-3">
                    <div class="category-card inventario animate-in" style="animation-delay: 0.4s;">
                        <div class="cat-icon-wrapper text-info">
                            <i class="fas fa-boxes"></i>
                        </div>
                        <h5 class="cat-title">Inventario</h5>
                        <p class="cat-desc d-none d-md-block">Movimientos de stock, kardex y valoración.</p>
                    </div>
                </div>
                 <!-- Operaciones -->
                 <div class="col-12 mb-3">
                    <div class="category-card otros animate-in" style="animation-delay: 0.5s;">
                        <div class="cat-icon-wrapper text-danger">
                            <i class="fas fa-cogs"></i>
                        </div>
                        <h5 class="cat-title">Operaciones</h5>
                        <p class="cat-desc d-none d-md-block">Anulaciones y auditoría operativa.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- RIGHT COLUMN: REPORT LIST -->
        <div class="col-lg-7">
            <div class="sub-report-card animate-in" style="animation-delay: 0.2s;">
                <div class="card-body p-0" id="list_a">
                    <!-- Default Empty State -->
                    <div class="empty-state">
                        <i class="ti-arrow-circle-left"></i>
                        <h3>Seleccione una Categoría</h3>
                        <p>Haga clic en una de las tarjetas de la izquierda para ver los reportes disponibles.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?php echo URL; ?>views/informe/js/inf.js"></script>
