$(function () {
	$('#navbar-c').addClass("white-bg");
	$('#informes').addClass("active");
});


function createHeader(title, iconClass, colorClass) {
	return $('<div class="sub-report-header ' + colorClass + ' bg-opacity-10 mb-2">' +
		'<h5 class="mb-0 font-weight-bold text-dark"><i class="' + iconClass + ' mr-2 ' + colorClass + '"></i>' + title + '</h5>' +
		'</div>');
}

function createLink(href, text, isNew = false) {
	var badge = isNew ? ' <span class="badge badge-danger ml-2">nuevo</span>' : '';
	return $('<a class="list-group-item list-group-item-action link" href="' + href + '">' +
		'<span>' + text + badge + '</span>' +
		'<i class="fas fa-chevron-right arrow text-muted small"></i>' +
		'</a>');
}

$(".ventas").click(function () {
	$('.category-card').removeClass('active-cat'); $(this).addClass('active-cat');
	$('#list_a').empty();
	$('#list_a').append(
		createHeader('Reportes de Ventas', 'fas fa-shopping-cart', 'text-success'),
		$('<div class="list-group list-group-flush list-group-modern animated fadeIn"/>')
			.append(createLink('informe/venta_all', 'Todas las ventas'))
			.append(createLink('informe/venta_del', 'Ventas por delivery'))
			.append(createLink('informe/venta_prod', 'Productos vendidos por canal de venta', true))
			.append(createLink('informe/venta_prod_kardex', 'Kardex de productos por ventas', true))
			.append(createLink('informe/venta_mozo', 'Ventas por mesero'))
			.append(createLink('informe/venta_fpago', 'Formas de pago'))
			.append(createLink('informe/venta_desc', 'Descuentos'))
			.append(createLink('informe/venta_cort', 'Cortesias', true))
	);
});

$(".compras").click(function () {
	$('.category-card').removeClass('active-cat'); $(this).addClass('active-cat');
	$('#list_a').empty();
	$('#list_a').append(
		createHeader('Reportes de Compras', 'fas fa-shopping-bag', 'text-primary'),
		$('<div class="list-group list-group-flush list-group-modern animated fadeIn"/>')
			.append(createLink('informe/compra_all', 'Todas las compras'))
	);
});

$(".finanzas").click(function () {
	$('.category-card').removeClass('active-cat'); $(this).addClass('active-cat');
	$('#list_a').empty();
	$('#list_a').append(
		createHeader('Reportes Financieros', 'fas fa-wallet', 'text-warning'),
		$('<div class="list-group list-group-flush list-group-modern animated fadeIn"/>')
			.append(createLink('informe/finanza_arq', 'Aperturas y cierres'))
			.append(createLink('informe/finanza_ing', 'Todos los ingresos'))
			.append(createLink('informe/finanza_egr', 'Todos los egresos'))
			.append(createLink('informe/finanza_rem', 'Egresos por remuneración'))
			.append(createLink('informe/finanza_adel', 'Personal'))
	);
});

$(".inventario").click(function () {
	$('.category-card').removeClass('active-cat'); $(this).addClass('active-cat');
	$('#list_a').empty();
	$('#list_a').append(
		createHeader('Reportes de Inventario', 'fas fa-boxes', 'text-info'),
		$('<div class="list-group list-group-flush list-group-modern animated fadeIn"/>')
			.append(createLink('informe/inventario_kardex', 'Kardex General'))
	);
});


$(".otros").click(function () {
	$('.category-card').removeClass('active-cat'); $(this).addClass('active-cat');
	$('#list_a').empty();
	$('#list_a').append(
		createHeader('Reportes de Operaciones', 'fas fa-cogs', 'text-danger'),
		$('<div class="list-group list-group-flush list-group-modern animated fadeIn"/>')
			.append(createLink('informe/oper_anul', 'Anulaciones de pedidos'))
	);
});


