<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y");
$fechaa = date("m-Y");
?>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 4px 20px rgba(0,0,0,0.05);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MODERN === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
    transition: color 0.2s;
}

.breadcrumb-modern a:hover {
    color: white;
    text-decoration: underline;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === STATS CONTAINER (GRID) === */
.stats-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    display: flex;
    align-items: center;
    border-bottom: 4px solid transparent;
    transition: var(--transition);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 15px rgba(0,0,0,0.1);
}

.stat-icon-wrapper {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    margin-right: 1.5rem;
    flex-shrink: 0;
}

.stat-content h2 {
    font-size: 1.8rem;
    font-weight: 700;
    margin-bottom: 0;
    color: #333;
}

.stat-content h6 {
    color: #8898aa;
    font-size: 0.85rem;
    margin-bottom: 0;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Variantes de Stats */
.stat-warning { border-color: var(--warning-color); }
.stat-warning .stat-icon-wrapper { background: rgba(244, 161, 0, 0.1); color: var(--warning-color); }

.stat-success { border-color: var(--success-color); }
.stat-success .stat-icon-wrapper { background: rgba(27, 201, 67, 0.1); color: var(--success-color); }

.stat-info { border-color: var(--info-color); }
.stat-info .stat-icon-wrapper { background: rgba(52, 152, 219, 0.1); color: var(--info-color); }

.stat-danger { border-color: var(--danger-color); }
.stat-danger .stat-icon-wrapper { background: rgba(231, 76, 60, 0.1); color: var(--danger-color); }

/* === FILTERS CARD === */
.filters-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    margin-bottom: 2rem;
}

.form-group-modern label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #555;
    margin-bottom: 0.5rem;
    display: block;
}

.form-control-modern {
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    padding: 0.6rem 1rem;
    font-size: 0.95rem;
    height: 45px;
    display: flex;
    align-items: center;
}

/* === CHART CARD === */
.chart-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    margin-bottom: 2rem;
}

/* === TABLE MODERN === */
.table-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    overflow: hidden;
}

.table-responsive-modern {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

.table-modern {
    margin-bottom: 0;
}

.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
    white-space: nowrap;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.01);
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === SCROLLBAR PERSONALIZADO === */
.table-responsive-modern::-webkit-scrollbar {
    height: 8px;
}

.table-responsive-modern::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
}

.table-responsive-modern::-webkit-scrollbar-thumb {
    background: var(--primary-color);
    border-radius: 10px;
}

.table-responsive-modern::-webkit-scrollbar-thumb:hover {
    background: #667eea;
}

.animate-in { animation: fadeInUp 0.6s ease; }
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

/* === RESPONSIVE STATS (MOBILE) === */
@media (max-width: 767px) {
    .stats-container {
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
    }
    .stat-card {
        padding: 15px;
        flex-direction: column;
        text-align: center;
        align-items: center;
        justify-content: center;
    }
    .stat-icon-wrapper {
        margin-right: 0;
        margin-bottom: 10px;
        width: 45px; 
        height: 45px;
        font-size: 1.1rem;
    }
    .stat-content h2 {
        font-size: 1.1rem;
    }
    .stat-content h6 {
        font-size: 0.7rem;
    }

    /* Header Mobile Improvements */
    .page-titles-modern {
        flex-direction: column;
        text-align: center;
        padding: 1.5rem 1rem;
    }
    .page-titles-modern > div {
        width: 100%;
        margin-bottom: 1rem;
    }
    .page-titles-modern .btn-group {
        width: 100%;
        margin-bottom: 0;
    }
    .page-titles-modern .btn {
        flex: 1;
    }
}
</style>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <div>
        <h4><i class="fas fa-chart-line mr-2"></i>Kardex de Productos</h4>
        <div class="breadcrumb-modern">
            <a href="<?php echo URL; ?>informe" class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Informe</a>
            <span class="breadcrumb-item">/</span>
            <span class="breadcrumb-item">Ventas</span>
            <span class="breadcrumb-item active">Kardex de Productos</span>
        </div>
    </div>
    <div class="btn-group">
        <button type="button" class="btn btn-light dropdown-toggle font-weight-bold shadow-sm" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-download mr-1"></i> Exportar
        </button>
        <div class="dropdown-menu dropdown-menu-right">
            <a class="dropdown-item" href="javascript:void(0);" id="excel"><i class="fas fa-file-excel text-success mr-2"></i> Excel</a>
            <a class="dropdown-item" href="javascript:void(0);" id="pdf"><i class="fas fa-file-pdf text-danger mr-2"></i> PDF</a>
        </div>
    </div>
</div>

<link href="<?php echo URL; ?>public/plugins/morrisjs/morris.css" rel="stylesheet">

<div class="wrapper wrapper-content animated fadeIn">
    <!-- STATS GRID -->
    <div class="stats-container animate-in">
        <!-- Cantidad Vendida -->
        <div class="stat-card stat-info">
            <div class="stat-icon-wrapper">
                <i class="fas fa-cubes"></i>
            </div>
            <div class="stat-content">
                <h2 class="productos-operaciones">0</h2>
                <h6>Cantidad Vendida</h6>
            </div>
        </div>
        <!-- Total Ventas -->
        <div class="stat-card stat-success">
            <div class="stat-icon-wrapper">
                <i class="fas fa-dollar-sign"></i>
            </div>
            <div class="stat-content">
                <h2 class="productos-total">0.00</h2>
                <h6>Total de Ventas</h6>
            </div>
        </div>
    </div>
    
    <!-- CHART CARD -->
    <div class="chart-card animate-in">
        <div id="chart-ventas-productos" style="height: 300px;"></div>
    </div>

    <!-- FILTERS -->
    <div class="filters-card animate-in">
        <form>
        <div class="row align-items-end">
            <!-- Rango Fechas -->
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="form-group-modern">
                    <label>Rango de Fechas</label>
                    <div class="input-group">
                        <input type="text" class="form-control form-control-modern text-center" name="start" id="start" value="<?php echo '01-'.$fechaa; ?>" autocomplete="off" placeholder="Inicio"/>
                        <div class="input-group-append">
                             <span class="input-group-text bg-light border-0">al</span>
                        </div>
                        <input type="text" class="form-control form-control-modern text-center" name="end" id="end" value="<?php echo $fecha; ?>" autocomplete="off" placeholder="Fin"/>
                    </div>
                </div>
            </div>
            <!-- Categoria -->
            <div class="col-lg-2 col-md-6 mb-3">
                 <div class="form-group-modern">
                    <label>Categor&iacute;a</label>
                    <select class="selectpicker form-control" name="filtro_categoria" id="filtro_categoria" data-style="btn-white border" data-live-search="true" autocomplete="off" data-size="5" title="Seleccionar">
                        <option value="%" selected>Seleccionar</option>
                        <optgroup>
                            <?php foreach($this->Categoria as $key => $value): ?>
                                <option value="<?php echo $value['id_catg']; ?>"><?php echo $value['descripcion']; ?></option>
                            <?php endforeach; ?>
                        </optgroup>
                    </select>
                </div>
            </div>
             <!-- Producto -->
             <div class="col-lg-4 col-md-6 mb-3">
                 <div class="form-group-modern">
                    <label>Producto</label>
                    <select class="selectpicker form-control" name="filtro_producto" id="filtro_producto" data-style="btn-white border" data-live-search="true" autocomplete="off" data-size="5" disabled title="Seleccionar">
                        <option value="%" selected>Seleccionar</option>
                        <optgroup>
                            <?php foreach($this->Producto as $key => $value): ?>
                                <option value="<?php echo $value['id_prod']; ?>"><?php echo $value['nombre']; ?></option>
                            <?php endforeach; ?>
                        </optgroup>
                    </select>
                </div>
            </div>
             <!-- Presentacion -->
             <div class="col-lg-3 col-md-6 mb-3">
                 <div class="form-group-modern">
                    <label>Presentaci&oacute;n</label>
                    <select class="selectpicker form-control" name="filtro_presentacion" id="filtro_presentacion" data-style="btn-white border" data-live-search="true" autocomplete="off" data-size="5" disabled title="Seleccionar">
                        <option value="%" selected>Seleccionar</option>
                        <optgroup>
                            <?php foreach($this->Presentacion as $key => $value): ?>
                                <option value="<?php echo $value['id_pres']; ?>"><?php echo $value['presentacion']; ?></option>
                            <?php endforeach; ?>
                        </optgroup>
                    </select>
                </div>
            </div>
        </div>
        </form>
    </div>

    <!-- TABLE -->
    <div class="table-card animate-in">
        <div class="table-responsive-modern">
            <table id="table" class="table table-modern" width="100%">
                 <thead>
                    <tr>
                        <th width="10%">Fecha</th>
                        <th width="15%">Documento</th>
                        <th width="10%">N° doc</th>
                        <th width="25%">Producto</th>
                        <th width="10%">Categor&iacute;a</th>
                        <th class="text-right" width="10%">Cantidad vendida</th>
                        <th class="text-right" width="10%">P.V.</th>
                        <th class="text-right" width="10%">Total</th>
                    </tr>
                </thead>
                <tbody class="tb-st"></tbody>
            </table>
        </div>
    </div>
</div>
