<?php
    $title = "Tablero";
    date_default_timezone_set($_SESSION["zona_horaria"]);
    setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
    $fecha = date("d-m-Y h:i A");
    $fechaa = date("d-m-Y 07:00");
?>
<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MODERNO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === CARDS MODERNAS === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    margin-bottom: 1.5rem;
    background: white;
    overflow: hidden;
    transition: var(--transition);
}

.card-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.12);
}

/* === ESTADISTICAS === */
.stats-card {
    position: relative;
    padding: 1.5rem;
    border-radius: var(--border-radius);
    overflow: hidden;
    color: white;
    margin-bottom: 1.5rem;
}

.stats-card h4 {
    color: white;
    opacity: 0.9;
    font-size: 1rem;
    margin-bottom: 0.5rem;
}

.stats-card h5 {
    color: white;
    font-size: 1.75rem;
    font-weight: 700;
    margin-bottom: 0;
}

.stats-icon {
    position: absolute;
    right: -10px;
    top: -10px;
    font-size: 5rem;
    opacity: 0.2;
    transform: rotate(15deg);
}

/* === PROGRESS BARS === */
.progress-modern {
    height: 6px;
    border-radius: 3px;
    background-color: rgba(0,0,0,0.05);
    margin-top: 10px;
}

/* === TABLES === */
.table-modern thead th {
    border-top: none;
    border-bottom: 2px solid #f0f0f0;
    color: var(--dark-color);
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.8rem;
}

.table-modern tbody td {
    vertical-align: middle;
    padding: 1rem 0.75rem;
}

/* === SELECT === */
.bootstrap-select .btn {
    border: 1px solid #ced4da !important;
    border-radius: 8px !important;
    padding: 0.75rem 1rem;
}

.animate-in {
    animation: fadeInUp 0.5s ease backwards;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

/* === OPTIMIZACIÓN MÓVIL === */
@media (max-width: 768px) {
    .page-titles-modern {
        padding: 1.2rem 1rem !important; /* Menos padding en móvil */
    }
    .page-titles-modern h4 {
        font-size: 1.25rem !important; /* Texto más pequeño */
        text-align: center;
    }
    .breadcrumb-modern {
        display: none; /* Ocultar breadcrumbs en móvil para ahorrar espacio */
    }
    .mobile-full-width {
        width: 100% !important;
        min-width: 100% !important;
        margin-top: 1rem;
    }
}
</style>

<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<input type="hidden" id="bloqueo" value="<?php echo Session::get('bloqueo'); ?>"/>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center">
        <div class="w-100 text-center text-md-left mb-2 mb-md-0">
            <h4><i class="fas fa-chart-line mr-2"></i>Tablero Principal</h4>
            <div class="breadcrumb-modern">
                <span class="breadcrumb-item"><a href="<?php echo URL; ?>"><i class="fas fa-home mr-1"></i>Inicio</a></span>
                <span class="breadcrumb-item active">Dashboard</span>
            </div>
        </div>
        <div class="ml-md-auto w-100 mobile-full-width">
            <div class="form-group mb-0 mobile-full-width" style="min-width: 250px;">
                <select class="selectpicker form-control" name="id_caja" id="id_caja" data-style="btn-light" data-live-search="true" title="Seleccionar Caja" <?php echo (Session::get('rol') == 1 || Session::get('rol') == 2 ) ? "" : "disabled"; ?>>
                    <?php foreach($this->Caja as $key => $value): ?>
                        <option value="<?php echo $value['id_apc']; ?>" <?php if (Session::get('apcid') == $value['id_apc'] ) { echo "selected"; } ?>><?php echo $value['desc_caja']; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
    </div>
</div>

<!-- INFO CARDS ROW 1 -->
<div class="row">
    <!-- Ventas Efectivo -->
    <div class="col-md-4 mb-3">
        <div class="card card-modern h-100 animate-in" style="animation-delay: 0.1s;">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5 class="text-muted"><i class="fas fa-money-bill-wave text-success mr-1"></i>Ventas Efectivo</h5>
                        <h2 class="font-weight-bold mb-0 text-dark"><span class="pago_efe"></span></h2>
                    </div>
                    <div class="align-self-center">
                         <span class="pago_efe_porcentaje badge badge-success-light text-success font-weight-bold p-2 ml-2"></span>
                    </div>
                </div>
                <div class="progress progress-modern">
                    <div class="progress-bar bg-success pago_efe_progressbar" role="progressbar" style="width: 0%"></div>
                </div>
                <small class="text-muted mt-2 d-block">No incluye apertura</small>
            </div>
        </div>
    </div>
    
    <!-- Ventas Otros Pagos -->
    <div class="col-md-4 mb-3">
        <div class="card card-modern h-100 animate-in" style="animation-delay: 0.2s;">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5 class="text-muted"><i class="fas fa-credit-card text-info mr-1"></i>Otros Medios</h5>
                        <h2 class="font-weight-bold mb-0 text-dark"><span class="pago_tar"></span></h2>
                    </div>
                    <div class="align-self-center">
                         <span class="pago_tar_porcentaje badge badge-info-light text-info font-weight-bold p-2 ml-2"></span>
                    </div>
                </div>
                <div class="progress progress-modern">
                    <div class="progress-bar bg-info pago_tar_progressbar" role="progressbar" style="width: 0%"></div>
                </div>
                <small class="text-muted mt-2 d-block">Tarjetas, Yape, Transferencias</small>
            </div>
        </div>
    </div>

    <!-- Total Ventas -->
    <div class="col-md-4 mb-3">
        <div class="card card-modern h-100 animate-in" style="border-left: 4px solid var(--primary-color); animation-delay: 0.3s;">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h5 class="text-primary font-weight-bold">TOTAL VENTAS</h5>
                        <h1 class="font-weight-bold mb-0 text-primary"><span class="total_ventas"></span></h1>
                    </div>
                    <div class="text-right">
                        <i class="fas fa-chart-pie fa-2x text-primary opacity-50"></i>
                    </div>
                </div>
                <div class="progress progress-modern">
                    <div class="progress-bar bg-primary" role="progressbar" style="width: 100%"></div>
                </div>
                <small class="text-muted mt-2 d-block">Incluye descuentos y delivery</small>
            </div>
        </div>
    </div>
</div>

<!-- DETAILED STATS & TABS -->
<div class="row">
    <!-- COLUMNA IZQUIERDA: Tabs Canal de Venta -->
    <div class="col-lg-4 mb-4">
        <div class="card card-modern h-100 animate-in" style="animation-delay: 0.4s;">
            <div class="card-body">
                <h4 class="card-title font-weight-bold mb-4">Por Canal de Venta</h4>
                
                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="pills-aprob-tab" data-toggle="pill" href="#tab1" role="tab"><span class="font-weight-bold">Aprobadas</span></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="pills-anul-tab" data-toggle="pill" href="#tab2" role="tab"><span class="font-weight-bold">Anuladas</span></a>
                    </li>
                </ul>
                
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="tab1" role="tabpanel">
                        <div class="mt-4">
                            <!-- Salon -->
                            <div class="d-flex align-items-center mb-4">
                                <div class="btn btn-circle btn-success text-white mr-3"><i class="fas fa-chair"></i></div>
                                <div class="w-100">
                                    <div class="d-flex justify-content-between">
                                        <h5 class="mb-0 font-weight-bold">Salones</h5>
                                        <h5 class="mb-0 font-weight-bold monto-venta-salon"></h5>
                                    </div>
                                    <small class="text-muted"><span class="cantidad-venta-salon"></span> ventas</small>
                                </div>
                            </div>
                            <!-- Mostrador -->
                            <div class="d-flex align-items-center mb-4">
                                <div class="btn btn-circle btn-primary text-white mr-3"><i class="fas fa-shopping-bag"></i></div>
                                <div class="w-100">
                                    <div class="d-flex justify-content-between">
                                        <h5 class="mb-0 font-weight-bold">Mostrador</h5>
                                        <h5 class="mb-0 font-weight-bold monto-venta-mostrador"></h5>
                                    </div>
                                    <small class="text-muted"><span class="cantidad-venta-mostrador"></span> ventas</small>
                                </div>
                            </div>
                            <!-- Delivery -->
                            <div class="d-flex align-items-center">
                                <div class="btn btn-circle btn-warning text-white mr-3"><i class="fas fa-motorcycle"></i></div>
                                <div class="w-100">
                                    <div class="d-flex justify-content-between">
                                        <h5 class="mb-0 font-weight-bold">Delivery</h5>
                                        <h5 class="mb-0 font-weight-bold monto-venta-delivery"></h5>
                                    </div>
                                    <small class="text-muted"><span class="cantidad-venta-delivery"></span> ventas</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tab-pane fade" id="tab2" role="tabpanel">
                        <div class="mt-4 opacity-50">
                             <!-- Salon Anul -->
                             <div class="d-flex align-items-center mb-4">
                                <div class="btn btn-circle btn-danger text-white mr-3"><i class="fas fa-chair"></i></div>
                                <div class="w-100">
                                    <div class="d-flex justify-content-between">
                                        <h5 class="mb-0 font-weight-bold">Salones</h5>
                                        <h5 class="mb-0 font-weight-bold monto-venta-salon-i"></h5>
                                    </div>
                                    <small class="text-muted"><span class="cantidad-venta-salon-i"></span> anuladas</small>
                                </div>
                            </div>
                            <!-- Mostrador Anul -->
                            <div class="d-flex align-items-center mb-4">
                                <div class="btn btn-circle btn-danger text-white mr-3"><i class="fas fa-shopping-bag"></i></div>
                                <div class="w-100">
                                    <div class="d-flex justify-content-between">
                                        <h5 class="mb-0 font-weight-bold">Mostrador</h5>
                                        <h5 class="mb-0 font-weight-bold monto-venta-mostrador-i"></h5>
                                    </div>
                                    <small class="text-muted"><span class="cantidad-venta-mostrador-i"></span> anuladas</small>
                                </div>
                            </div>
                            <!-- Delivery Anul -->
                            <div class="d-flex align-items-center">
                                <div class="btn btn-circle btn-danger text-white mr-3"><i class="fas fa-motorcycle"></i></div>
                                <div class="w-100">
                                    <div class="d-flex justify-content-between">
                                        <h5 class="mb-0 font-weight-bold">Delivery</h5>
                                        <h5 class="mb-0 font-weight-bold monto-venta-delivery-i"></h5>
                                    </div>
                                    <small class="text-muted"><span class="cantidad-venta-delivery-i"></span> anuladas</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- COLUMNA DERECHA: Grid de Tarjetas de Colores -->
    <div class="col-lg-8">
        <div class="row">
            <div class="col-md-6">
                <div class="stats-card bg-success animate-in" style="animation-delay: 0.5s;">
                    <i class="fas fa-donate stats-icon"></i>
                    <h4>Ingresos Caja</h4>
                    <h5 class="ingresos">S/ 0.00</h5>
                </div>
            </div>
            <div class="col-md-6">
                <div class="stats-card bg-danger animate-in" style="animation-delay: 0.55s;">
                    <i class="fas fa-hand-holding-usd stats-icon"></i>
                    <h4>Egresos Caja</h4>
                    <h5 class="egresos">S/ 0.00</h5>
                </div>
            </div>
            <div class="col-md-6">
                <div class="stats-card bg-warning animate-in" style="animation-delay: 0.6s;">
                    <i class="fas fa-percent stats-icon"></i>
                    <h4>Descuentos</h4>
                    <h5 class="descuentos">S/ 0.00</h5>
                </div>
            </div>
            <div class="col-md-6">
                <div class="stats-card bg-info animate-in" style="animation-delay: 0.65s;">
                    <i class="fas fa-motorcycle stats-icon"></i>
                    <h4>Comisión Delivery</h4>
                    <h5 class="comision-delivery">S/ 0.00</h5>
                </div>
            </div>
            <div class="col-md-6">
                <div class="stats-card bg-secondary animate-in" style="animation-delay: 0.7s; background: #6c757d !important;">
                    <i class="fas fa-calculator stats-icon"></i>
                    <h4>Cálculo Efectivo</h4>
                    <h5 class="efectivo_real">S/ 0.00</h5>
                </div>
            </div>
            <div class="col-md-6">
                <div class="stats-card bg-primary animate-in" style="animation-delay: 0.75s;">
                    <i class="fas fa-cash-register stats-icon"></i>
                    <h4>Apertura Caja</h4>
                    <h5 class="apertura_caja">S/ 0.00</h5>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- TOP PRODUCTOS Y PLATOS -->
<div class="row">
    <div class="col-lg-6 mb-4">
        <div class="card card-modern h-100 animate-in" style="animation-delay: 0.8s;">
            <div class="card-body p-0">
                <div class="p-3 border-bottom">
                    <h5 class="card-title font-weight-bold mb-0 text-dark"><i class="fas fa-star text-warning mr-2"></i>Top 10 Productos</h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-modern table-hover mb-0">
                        <thead>
                            <tr>
                                <th colspan="2">Producto</th>
                                <th class="text-center">Ventas</th>
                                <th class="text-right">Importe</th>
                                <th class="text-right">%</th>
                            </tr>
                        </thead>
                        <tbody id="lista_productos"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-6 mb-4">
        <div class="card card-modern h-100 animate-in" style="animation-delay: 0.9s;">
            <div class="card-body p-0">
                <div class="p-3 border-bottom">
                    <h5 class="card-title font-weight-bold mb-0 text-dark"><i class="fas fa-utensils text-danger mr-2"></i>Top 10 Platos</h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-modern table-hover mb-0">
                        <thead>
                            <tr>
                                <th colspan="2">Plato</th>
                                <th class="text-center">Ventas</th>
                                <th class="text-right">Importe</th>
                                <th class="text-right">%</th>
                            </tr>
                        </thead>
                        <tbody id="lista_platos"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Re-initialize selectpicker if needed
    if ($.fn.selectpicker) {
        $('.selectpicker').selectpicker('render');
    }
});
</script>